/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotSearchBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;

public class AIRobotSearchAndGotoBlock
extends AIRobot {
    private BlockPos blockFound = null;
    private IBlockFilter filter = null;
    private boolean random = false;
    private double maxDistanceToEnd;

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot, boolean iRandom, IBlockFilter iPathFound) {
        this(iRobot, iRandom, iPathFound, 0.0);
    }

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot, boolean iRandom, IBlockFilter iPathFound, double iMaxDistanceToEnd) {
        this(iRobot);
        this.random = iRandom;
        this.filter = iPathFound;
        this.maxDistanceToEnd = iMaxDistanceToEnd;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchBlock(this.robot, this.random, this.filter, this.maxDistanceToEnd));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            if (ai.success()) {
                AIRobotSearchBlock searchAI = (AIRobotSearchBlock)ai;
                if (searchAI.takeResource()) {
                    this.blockFound = searchAI.blockFound;
                    this.startDelegateAI(new AIRobotGotoBlock(this.robot, searchAI.path));
                } else {
                    this.terminate();
                }
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (!ai.success()) {
                this.releaseBlockFound();
            }
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public BlockPos getBlockFound() {
        return this.blockFound;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("indexStored", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("indexStored")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("indexStored"));
        }
    }
}

