/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.statements.ActionRobotFilter;
import buildcraft.robotics.statements.ActionStationProvideFluids;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotLoadFluids
extends AIRobot {
    private int waitedCycles = 0;
    private IFluidFilter filter;

    public AIRobotLoadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotLoadFluids(EntityRobotBase iRobot, IFluidFilter iFilter) {
        this(iRobot);
        this.filter = iFilter;
        this.setSuccess(false);
    }

    @Override
    public void update() {
        if (this.filter == null) {
            this.terminate();
            return;
        }
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            if (AIRobotLoadFluids.load(this.robot, this.robot.getDockingStation(), this.filter, true) == 0) {
                this.terminate();
            } else {
                this.setSuccess(true);
                this.waitedCycles = 0;
            }
        }
    }

    public static int load(EntityRobotBase robot, DockingStation station, IFluidFilter filter, boolean doLoad) {
        if (station == null) {
            return 0;
        }
        if (!ActionRobotFilter.canInteractWithFluid(station, filter, ActionStationProvideFluids.class)) {
            return 0;
        }
        IFluidHandler handler = station.getFluidInput();
        if (handler == null) {
            return 0;
        }
        EnumFacing side = station.getFluidInputSide().face;
        FluidStack drainable = handler.drain(side, 1000, false);
        if (drainable == null || !filter.matches(drainable.getFluid())) {
            return 0;
        }
        int filled = robot.fill(null, drainable = drainable.copy(), doLoad);
        if (filled > 0 && doLoad) {
            drainable.amount = filled;
            handler.drain(side, drainable, true);
        }
        return filled;
    }

    @Override
    public int getEnergyCost() {
        return 8;
    }
}

