/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.ai.AIRobotLoad;
import buildcraft.robotics.ai.AIRobotSearchAndGotoStation;

public class AIRobotGotoStationToLoad
extends AIRobot {
    private IStackFilter filter;
    private int quantity;

    public AIRobotGotoStationToLoad(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToLoad(EntityRobotBase iRobot, IStackFilter iFilter, int iQuantity) {
        this(iRobot);
        this.filter = iFilter;
        this.quantity = iQuantity;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationFilter(), this.robot.getZoneToLoadUnload()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.setSuccess(ai.success());
            this.terminate();
        }
    }

    private class StationFilter
    implements IStationFilter {
        private StationFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            return AIRobotLoad.load(AIRobotGotoStationToLoad.this.robot, station, AIRobotGotoStationToLoad.this.filter, AIRobotGotoStationToLoad.this.quantity, false);
        }
    }
}

