/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.robots.DockingStation;
import buildcraft.core.lib.utils.NBTUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;

public class StationIndex {
    public BlockPos index = new BlockPos(0, 0, 0);
    public EnumFacing side = null;

    protected StationIndex() {
    }

    public StationIndex(EnumFacing iSide, BlockPos pos) {
        this.side = iSide;
        this.index = new BlockPos((Vec3i)pos);
    }

    public StationIndex(DockingStation station) {
        this.side = station.side();
        this.index = station.index();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StationIndex compareId = (StationIndex)obj;
        return this.index.equals((Object)compareId.index) && this.side == compareId.side;
    }

    public int hashCode() {
        return this.index.hashCode() * 37 + this.side.ordinal();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("index", NBTUtils.writeBlockPos(this.index));
        nbt.func_74774_a("side", (byte)this.side.ordinal());
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.index = NBTUtils.readBlockPos(nbt.func_74781_a("index"));
        this.side = EnumFacing.values()[nbt.func_74771_c("side")];
    }
}

