/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IComplexRefineryRecipeManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class TileHeatExchange
extends TileBuildCraft
implements IFluidHandler,
IHasWork,
IControllable,
IDebuggable,
IInventory {
    private final Tank inCoolable;
    private final Tank outCooled;
    private final Tank inHeatable;
    private final Tank outHeated;
    private final TankManager<Tank> manager;
    private SafeTimeTracker networkUpdateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private IComplexRefineryRecipeManager.IHeatableRecipe heatableRecipe;
    private IComplexRefineryRecipeManager.ICoolableRecipe coolableRecipe;
    private int sleep = 0;
    private int lateSleep = 0;
    private long lastCraftTick = -1L;

    public TileHeatExchange() {
        this.inCoolable = new Tank("inCoolable", 1000, this);
        this.outCooled = new Tank("outCooled", 1000, this);
        this.inHeatable = new Tank("inHeatable", 1000, this);
        this.outHeated = new Tank("outHeated", 1000, this);
        this.manager = new TankManager(new Tank[]{this.inCoolable, this.outCooled, this.inHeatable, this.outHeated});
        this.mode = IControllable.Mode.On;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.manager.deserializeNBT(nbt.func_74775_l("tanks"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)this.manager.serializeNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(ByteBuf stream) {
        this.manager.readData(stream);
        this.sleep = stream.readInt();
        this.lastCraftTick = stream.readLong();
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.manager.writeData(stream);
        stream.writeInt(this.sleep);
        stream.writeLong(this.lastCraftTick);
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getInputCoolable() {
        return this.inCoolable;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getInputHeatable() {
        return this.inHeatable;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getOutputCooled() {
        return this.outCooled;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getOutputHeated() {
        return this.outHeated;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCraftedRecently() {
        return this.lastCraftTick + 30L > this.field_145850_b.func_82737_E();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.networkUpdateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        this.craft();
        this.export();
    }

    private void craft() {
        this.checkRecipe();
        if (this.mode == IControllable.Mode.On && this.hasWork()) {
            if (this.sleep > 0) {
                --this.sleep;
                return;
            }
            this.exchangeHeat();
        }
    }

    private void export() {
        this.exportCooled();
        this.exportHeated();
    }

    private void exportCooled() {
        if (this.outCooled.getFluidAmount() <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.heatExchangeBlock) {
            return;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(exportDir));
        if (!(tile instanceof IPipeTile)) {
            return;
        }
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        IFluidHandler fluid = (IFluidHandler)tile;
        if (!fluid.canFill(exportDir.func_176734_d(), this.outCooled.getFluidType())) {
            return;
        }
        FluidStack stack = this.outCooled.drain(20, true);
        int filled = fluid.fill(exportDir.func_176734_d(), stack, true);
        if (filled < stack.amount) {
            FluidStack back = stack.copy();
            back.amount -= filled;
            this.outCooled.fill(back, true);
        }
    }

    private void exportHeated() {
        if (this.outHeated.getFluidAmount() <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.heatExchangeBlock) {
            return;
        }
        EnumFacing exportDir = EnumFacing.UP;
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(exportDir));
        if (!(tile instanceof IPipeTile)) {
            return;
        }
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        IFluidHandler fluid = (IFluidHandler)tile;
        if (!fluid.canFill(exportDir.func_176734_d(), this.outHeated.getFluidType())) {
            return;
        }
        FluidStack stack = this.outHeated.drain(20, true);
        int filled = fluid.fill(exportDir.func_176734_d(), stack, true);
        if (filled < stack.amount) {
            FluidStack back = stack.copy();
            back.amount -= filled;
            this.outHeated.fill(back, true);
        }
    }

    private void checkRecipe() {
        boolean reset = false;
        if (this.heatableRecipe != null && !this.heatableRecipe.in().equals((Object)this.inHeatable.getFluid())) {
            this.heatableRecipe = null;
        }
        if (this.coolableRecipe != null && !this.coolableRecipe.in().equals((Object)this.inCoolable.getFluid())) {
            this.coolableRecipe = null;
        }
        if (this.heatableRecipe == null) {
            reset = true;
            this.heatableRecipe = BuildcraftRecipeRegistry.complexRefinery.getHeatableRegistry().getRecipeForInput(this.inHeatable.getFluid());
        }
        if (this.coolableRecipe == null) {
            reset = true;
            this.coolableRecipe = BuildcraftRecipeRegistry.complexRefinery.getCoolableRegistry().getRecipeForInput(this.inCoolable.getFluid());
        }
        if (this.heatableRecipe != null && this.coolableRecipe != null && reset) {
            this.sleep = Math.max(this.heatableRecipe.ticks(), this.coolableRecipe.ticks());
        }
    }

    private void exchangeHeat() {
        FluidStack coolant = this.inCoolable.drain(this.coolableRecipe.in().amount, true);
        FluidStack heatant = this.inHeatable.drain(this.heatableRecipe.in().amount, true);
        if (coolant.amount != this.coolableRecipe.in().amount || heatant.amount != this.heatableRecipe.in().amount) {
            this.inCoolable.fill(coolant, true);
            this.inHeatable.fill(heatant, true);
            return;
        }
        this.outCooled.fill(this.coolableRecipe.out(), true);
        this.outHeated.fill(this.heatableRecipe.out(), true);
        this.sleep = Math.max(this.coolableRecipe.ticks(), this.heatableRecipe.ticks());
        this.lastCraftTick = this.field_145850_b.func_82737_E();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (from.func_176740_k() == EnumFacing.Axis.Y) {
            IComplexRefineryRecipeManager.IHeatableRecipe potential = BuildcraftRecipeRegistry.complexRefinery.getHeatableRegistry().getRecipeForInput(resource);
            if (potential == null) {
                return 0;
            }
            if (this.heatableRecipe != null && potential != this.heatableRecipe) {
                return 0;
            }
            if (this.coolableRecipe == null || potential.heatFrom() < this.coolableRecipe.heatFrom()) {
                return this.inHeatable.fill(resource, doFill);
            }
            return 0;
        }
        IComplexRefineryRecipeManager.ICoolableRecipe potential = BuildcraftRecipeRegistry.complexRefinery.getCoolableRegistry().getRecipeForInput(resource);
        if (potential == null) {
            return 0;
        }
        if (this.coolableRecipe != null && potential != this.coolableRecipe) {
            return 0;
        }
        if (this.heatableRecipe == null || this.heatableRecipe.heatFrom() < potential.heatFrom()) {
            return this.inCoolable.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from.func_176740_k() != EnumFacing.Axis.Y) {
            if (this.outCooled.isEmpty()) {
                return null;
            }
            if (this.outCooled.getFluid().equals((Object)resource)) {
                return this.outCooled.drain(resource.amount, doDrain);
            }
        } else {
            if (this.outHeated.isEmpty()) {
                return null;
            }
            if (this.outHeated.getFluid().equals((Object)resource)) {
                return this.outHeated.drain(resource.amount, doDrain);
            }
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from.func_176740_k() != EnumFacing.Axis.Y) {
            return this.outCooled.drain(maxDrain, doDrain);
        }
        return this.outHeated.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.fill(from, new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.drain(from, new FluidStack(fluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.inCoolable.getInfo(), this.inHeatable.getInfo(), this.outCooled.getInfo(), this.outHeated.getInfo()};
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off;
    }

    @Override
    public boolean hasWork() {
        return this.hasWork(true);
    }

    private boolean hasWork(boolean care) {
        if (this.heatableRecipe == null) {
            return false;
        }
        if (this.coolableRecipe == null) {
            return false;
        }
        boolean ret = true;
        ret &= !care || this.inHeatable.getFluidAmount() >= this.heatableRecipe.in().amount;
        ret &= this.outHeated.isEmpty() || this.outHeated.getFluid().equals((Object)this.heatableRecipe.out());
        ret &= this.outHeated.getCapacity() - this.outHeated.getFluidAmount() >= this.heatableRecipe.out().amount;
        ret &= !care || this.inCoolable.getFluidAmount() >= this.coolableRecipe.in().amount;
        ret &= this.outCooled.isEmpty() || this.outCooled.getFluid().equals((Object)this.coolableRecipe.out());
        return ret &= this.outCooled.getCapacity() - this.outCooled.getFluidAmount() >= this.coolableRecipe.out().amount;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        Tank[] tanks = new Tank[]{this.inCoolable, this.inHeatable, this.outCooled, this.outHeated};
        left.add("");
        left.add("Sleep = " + this.sleep);
        for (Tank t : tanks) {
            left.add(StringUtils.capitalize((String)t.getTankName()) + ":");
            left.add(" " + t.getFluidAmount() + "/" + t.getCapacity() + "mB");
            left.add(" " + (t.getFluid() == null ? "empty" : t.getFluidType().getLocalizedName(t.getFluid())));
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.func_94041_b(index, stack)) {
            // empty if block
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }
}

