/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IComplexRefineryRecipeManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyHeater
extends TileBuildCraft
implements IFluidHandler,
IHasWork,
IControllable,
IDebuggable,
IInventory {
    private final Tank in;
    private final Tank out;
    private final TankManager<Tank> manager;
    private final SafeTimeTracker networkTimeTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private IComplexRefineryRecipeManager.IHeatableRecipe currentRecipe;
    private int sleep = 0;
    private long lastCraftTick = -1L;

    public TileEnergyHeater() {
        this.setBattery(new RFBattery(1000, 20, 0));
        this.in = new Tank("in", 1000, this);
        this.out = new Tank("out", 1000, this);
        this.manager = new TankManager(new Tank[]{this.in, this.out});
        this.mode = IControllable.Mode.On;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.manager.deserializeNBT(nbt.func_74775_l("tanks"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)this.manager.serializeNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(ByteBuf stream) {
        this.getBattery().setEnergy(stream.readInt());
        this.manager.readData(stream);
        this.sleep = stream.readInt();
        this.lastCraftTick = stream.readLong();
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeInt(this.getBattery().getEnergyStored());
        this.manager.writeData(stream);
        stream.writeInt(this.sleep);
        stream.writeLong(this.lastCraftTick);
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getInputTank() {
        return this.in;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getOutputTank() {
        return this.out;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCraftedRecently() {
        return this.lastCraftTick + 30L > this.field_145850_b.func_82737_E();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEnergy() {
        this.checkRecipe();
        if (this.currentRecipe == null) {
            return this.getBattery().getEnergyStored() > 10;
        }
        int heatDiff = this.currentRecipe.heatTo() - this.currentRecipe.heatFrom();
        int required = heatDiff * BuildCraftFactory.rfPerHeatPerMB * this.currentRecipe.ticks() * this.currentRecipe.in().amount;
        return this.getBattery().getEnergyStored() >= required;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.networkTimeTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        this.craft();
        this.export();
    }

    private void craft() {
        this.checkRecipe();
        if (this.mode == IControllable.Mode.On && this.hasWork()) {
            if (this.sleep > 0) {
                --this.sleep;
                return;
            }
            this.heat();
        }
    }

    private void export() {
        if (this.out.getFluidAmount() <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(exportDir));
        if (!(tile instanceof IPipeTile)) {
            return;
        }
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        IFluidHandler fluid = (IFluidHandler)tile;
        if (!fluid.canFill(exportDir.func_176734_d(), this.out.getFluidType())) {
            return;
        }
        FluidStack stack = this.out.drain(20, true);
        int filled = fluid.fill(exportDir.func_176734_d(), stack, true);
        if (filled < stack.amount) {
            FluidStack back = stack.copy();
            back.amount -= filled;
            this.out.fill(back, true);
        }
    }

    private void checkRecipe() {
        if (this.currentRecipe == null) {
            this.currentRecipe = BuildcraftRecipeRegistry.complexRefinery.getHeatableRegistry().getRecipeForInput(this.in.getFluid());
            if (this.currentRecipe != null) {
                this.resetSleep();
            }
            return;
        }
        if (!this.currentRecipe.in().equals((Object)this.in.getFluid())) {
            this.currentRecipe = null;
        }
    }

    private void heat() {
        int heatDiff = this.currentRecipe.heatTo() - this.currentRecipe.heatFrom();
        int required = heatDiff * BuildCraftFactory.rfPerHeatPerMB * this.currentRecipe.ticks() * Math.min(this.in.getFluidAmount(), this.currentRecipe.in().amount);
        if (this.getBattery().useEnergy(required, required, false) == required) {
            FluidStack stack = this.in.drain(this.currentRecipe.in().amount, true);
            if (stack.amount < this.currentRecipe.in().amount) {
                this.in.fill(stack, true);
            } else {
                this.out.fill(this.currentRecipe.out(), true);
                this.resetSleep();
                this.lastCraftTick = this.field_145850_b.func_82737_E();
            }
        }
    }

    private void resetSleep() {
        double multiplier = this.in.getCapacity() - this.in.getFluidAmount();
        multiplier /= (double)this.in.getCapacity();
        if ((multiplier *= 3.0) < 1.0) {
            multiplier = 1.0;
        }
        this.sleep = this.currentRecipe.ticks() * (int)multiplier;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return 0;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        if (exportDir.func_176734_d() != from) {
            return 0;
        }
        if (BuildcraftRecipeRegistry.complexRefinery.getHeatableRegistry().getRecipeForInput(resource) == null) {
            return 0;
        }
        return this.in.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return null;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        if (exportDir != from) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        if (this.out.getFluid().equals((Object)resource)) {
            return this.out.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return null;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        if (exportDir != from) {
            return null;
        }
        return this.out.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return false;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        if (exportDir.func_176734_d() != from) {
            return false;
        }
        return this.in.fill(new FluidStack(fluid, 1), false) == 1;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.energyHeaterBlock) {
            return false;
        }
        EnumFacing curFace = (EnumFacing)state.func_177229_b(BlockBuildCraftBase.FACING_PROP);
        EnumFacing exportDir = curFace.func_176735_f();
        if (exportDir != from) {
            return false;
        }
        return this.out.drain(1, false) != null;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.in.getInfo(), this.out.getInfo()};
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off;
    }

    @Override
    public boolean hasWork() {
        return this.hasWork(true);
    }

    private boolean hasWork(boolean care) {
        if (this.currentRecipe == null) {
            return false;
        }
        boolean ret = !care || this.in.getFluidAmount() >= this.currentRecipe.in().amount;
        ret &= this.out.isEmpty() || this.out.getFluid().equals((Object)this.currentRecipe.out());
        return ret &= this.out.getCapacity() - this.out.getFluidAmount() >= this.currentRecipe.out().amount;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        Tank[] tanks = new Tank[]{this.in, this.out};
        left.add("");
        left.add("Sleep = " + this.sleep);
        left.add("Power = " + this.getBattery().getEnergyStored() + "RF");
        left.add("Input");
        left.add(" " + tanks[0].getFluidAmount() + "/" + tanks[0].getCapacity() + "mB");
        left.add(" " + (tanks[0].getFluid() == null ? "empty" : tanks[0].getFluidType().getLocalizedName(tanks[0].getFluid())));
        left.add("Output");
        left.add(" " + tanks[1].getFluidAmount() + "/" + tanks[1].getCapacity() + "mB");
        left.add(" " + (tanks[1].getFluid() == null ? "empty" : tanks[1].getFluidType().getLocalizedName(tanks[1].getFluid())));
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.func_94041_b(index, stack)) {
            // empty if block
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }
}

