/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.schematics;

import buildcraft.BuildCraftFactory;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.JavaTools;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.factory.TileAutoWorkbench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class SchematicAutoWorkbench
extends SchematicTile {
    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        TileAutoWorkbench autoWb = this.getTile(context, pos);
        if (autoWb != null) {
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            rqs.add(new ItemStack((Block)BuildCraftFactory.autoWorkbenchBlock));
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)autoWb.craftMatrix, EnumFacing.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null) continue;
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
                rqs.add(stack);
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, BlockPos pos) {
        super.initializeFromObjectAt(context, pos);
        this.tileNBT.func_82580_o("Items");
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        super.placeInWorld(context, pos, stacks);
        TileAutoWorkbench autoWb = this.getTile(context, pos);
        if (autoWb != null) {
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)autoWb.craftMatrix, EnumFacing.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null) continue;
                stack.field_77994_a = 1;
            }
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }

    private TileAutoWorkbench getTile(IBuilderContext context, BlockPos pos) {
        TileEntity tile = context.world().func_175625_s(pos);
        if (tile != null && tile instanceof TileAutoWorkbench) {
            return (TileAutoWorkbench)tile;
        }
        return null;
    }
}

