/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.refining;

import buildcraft.BuildCraftEnergy;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IComplexRefineryRecipeManager;
import buildcraft.core.lib.client.sprite.SpriteColourMapper;
import buildcraft.core.lib.fluids.FluidDefinition;
import buildcraft.core.lib.utils.ModelHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComplexRefiningManager {
    public static FluidDefinition[] crudeOil;
    public static FluidDefinition[] oilDistilled;
    public static FluidDefinition[] oilHeavy;
    public static FluidDefinition[] fuelMixedLight;
    public static FluidDefinition[] fuelMixedHeavy;
    public static FluidDefinition[] oilDense;
    public static FluidDefinition[] fuelGaseous;
    public static FluidDefinition[] fuelLight;
    public static FluidDefinition[] fuelDense;
    public static FluidDefinition[] oilResidue;
    public static FluidDefinition tar;
    public static FluidDefinition steam;
    private static final List<FluidDefinition> allFluids;

    public static void preInit() {
        int[][] colours = new int[][]{{0x505050, 328965}, {0x100F10, 69275458}, {10522399, 4338976}, {8875639, 0x422424}, {14991224, 10784512}, {0xFFAF3F, 14712576}, {15902464, 12879616}, {0xFFFF30, 14995200}, {16176896, 12891904}, {16447024, 14735616}, {0x3F3F3F, 0x303030}, {0xFFFFFF, 0xAFAFAF}};
        int index = 0;
        crudeOil = ComplexRefiningManager.defineFluids("oil", 4000, 4000, 3, 4, colours[index][0], colours[index++][1]);
        oilResidue = ComplexRefiningManager.defineFluids("oilResidue", 6000, 8000, 3, 4, colours[index][0], colours[index++][1]);
        oilHeavy = ComplexRefiningManager.defineFluids("oilHeavy", 4000, 4000, 3, 2, colours[index][0], colours[index++][1]);
        oilDense = ComplexRefiningManager.defineFluids("oilDense", 5000, 5000, 3, 4, colours[index][0], colours[index++][1]);
        oilDistilled = ComplexRefiningManager.defineFluids("oilDistilled", 3000, 3500, 3, 2, colours[index][0], colours[index++][1]);
        fuelDense = ComplexRefiningManager.defineFluids("fuelDense", 2000, 5000, 3, 2, colours[index][0], colours[index++][1]);
        fuelMixedHeavy = ComplexRefiningManager.defineFluids("fuelMixedHeavy", 1200, 700, 3, 2, colours[index][0], colours[index++][1]);
        fuelLight = new FluidDefinition[]{ComplexRefiningManager.defineFluid("fuel", 1000, 900, 0, 1, colours[index][0], colours[index][1]), ComplexRefiningManager.defineFluid("fuelLight", 1000, 900, 1, 1, colours[index][0], colours[index][1]), ComplexRefiningManager.defineFluid("fuelLight", 1000, 900, 2, 1, colours[index][0], colours[index][1]), ComplexRefiningManager.defineFluid("fuelLight", 1000, 900, 3, 1, colours[index][0], colours[index++][1])};
        ComplexRefiningManager.fuelLight[0].fluid.setHeatable(true);
        fuelMixedLight = ComplexRefiningManager.defineFluids("fuelMixedLight", 800, 700, 3, 1, colours[index][0], colours[index++][1]);
        fuelGaseous = ComplexRefiningManager.defineFluids("fuelGaseous", 300, 600, 3, 0, colours[index][0], colours[index++][1]);
        tar = ComplexRefiningManager.defineFluid("tar", 7000, 8000, 0, 4, colours[index][0], colours[index++][1]);
        steam = ComplexRefiningManager.defineFluid("steam", 100, 1000, 2, 1, colours[index][0], colours[index++][1]);
        BuildCraftEnergy.oil = crudeOil[0];
        BuildCraftEnergy.oil.block.setDense(true);
        BuildCraftEnergy.fuel = fuelLight[0];
    }

    private static FluidDefinition[] defineFluids(String name, int density, int baseViscocity, int maxHeat, int boilPoint, int texColourLight, int texColourDark) {
        FluidDefinition[] arr = new FluidDefinition[maxHeat + 1];
        for (int h = 0; h <= maxHeat; ++h) {
            arr[h] = ComplexRefiningManager.defineFluid(name, density, baseViscocity, h, boilPoint, texColourLight, texColourDark);
        }
        if (maxHeat > 0) {
            arr[0].fluid.setHeatable(true);
        }
        return arr;
    }

    private static FluidDefinition defineFluid(String name, int density, int baseViscocity, int heat, int boilPoint, int texColourLight, int texColourDark) {
        String fullName = name + (heat == 0 ? "" : "_heat_" + heat);
        int tempAdjustedViscocity = baseViscocity * (5 - heat) / 5;
        int boilAdjustedDensity = density * (heat >= boilPoint ? -1 : 1);
        boolean bucket = true;
        FluidDefinition def = new FluidDefinition(fullName, fullName, boilAdjustedDensity, tempAdjustedViscocity, bucket, 0xFF000000 | texColourLight, 0xFF000000 | texColourDark);
        if (def.bucket != null && heat != 0) {
            def.bucket.func_77637_a(null);
        }
        def.fluid.setHeat(heat);
        def.fluid.setUnlocalizedName(name);
        def.fluid.setTemperature(300 + 20 * heat);
        if (heat > 0) {
            def.fluid.setHeatable(true);
        }
        allFluids.add(def);
        return def;
    }

    public static void init() {
        ComplexRefiningManager.addBiDirectionalHeatExchange(crudeOil, 10, 7);
        ComplexRefiningManager.addBiDirectionalHeatExchange(oilDistilled, 10, 4);
        ComplexRefiningManager.addBiDirectionalHeatExchange(oilHeavy, 10, 6);
        ComplexRefiningManager.addBiDirectionalHeatExchange(oilDense, 10, 6);
        ComplexRefiningManager.addBiDirectionalHeatExchange(fuelMixedHeavy, 10, 5);
        ComplexRefiningManager.addBiDirectionalHeatExchange(fuelMixedLight, 10, 4);
        ComplexRefiningManager.addBiDirectionalHeatExchange(oilResidue, 10, 8);
        ComplexRefiningManager.addBiDirectionalHeatExchange(fuelDense, 10, 5);
        ComplexRefiningManager.addBiDirectionalHeatExchange(fuelLight, 10, 4);
        ComplexRefiningManager.addBiDirectionalHeatExchange(fuelGaseous, 10, 3);
        BuildcraftRecipeRegistry.complexRefinery.addHeatableRecipe(new FluidStack(FluidRegistry.WATER, 10), steam.createFluidStack(10), 0, 2, 3, false);
        int _oil = 4;
        int _gas = 32;
        int _light = 8;
        int _dense = 2;
        boolean _residue = true;
        int _gas_light = 10;
        int _light_dense = 5;
        int _dense_residue = 2;
        int _light_dense_residue = 5;
        int _gas_light_dense = 10;
        ComplexRefiningManager.addDistilationRecipe(crudeOil[1], 4, fuelGaseous[1], 32, oilHeavy[1], 5, 12);
        ComplexRefiningManager.addDistilationRecipe(crudeOil[2], 4, fuelMixedLight[2], 10, oilDense[2], 2, 8);
        ComplexRefiningManager.addDistilationRecipe(crudeOil[3], 4, oilDistilled[3], 10, oilResidue[3], 1, 4);
        ComplexRefiningManager.addDistilationRecipe(oilDistilled[1], 10, fuelGaseous[1], 32, fuelMixedHeavy[1], 5, 6);
        ComplexRefiningManager.addDistilationRecipe(oilDistilled[2], 10, fuelMixedLight[2], 10, fuelDense[2], 2, 4);
        ComplexRefiningManager.addDistilationRecipe(oilHeavy[2], 5, fuelLight[2], 8, oilDense[2], 2, 4);
        ComplexRefiningManager.addDistilationRecipe(oilHeavy[3], 5, fuelMixedHeavy[3], 5, oilResidue[3], 1, 4);
        ComplexRefiningManager.addDistilationRecipe(fuelMixedLight[1], 10, fuelGaseous[1], 32, fuelLight[1], 8, 6);
        ComplexRefiningManager.addDistilationRecipe(fuelMixedHeavy[2], 5, fuelLight[2], 8, fuelDense[2], 2, 6);
        ComplexRefiningManager.addDistilationRecipe(oilDense[3], 2, fuelDense[3], 2, oilResidue[3], 1, 6);
        ComplexRefiningManager.addNormalFuel(fuelGaseous[0], 32, 8.0, 1.0);
        ComplexRefiningManager.addNormalFuel(fuelLight[0], 8, 6.0, 1.0);
        ComplexRefiningManager.addNormalFuel(fuelDense[0], 2, 4.0, 1.0);
        ComplexRefiningManager.addNormalFuel(fuelMixedLight[0], 10, 6.5, 0.75);
        ComplexRefiningManager.addNormalFuel(fuelMixedHeavy[0], 5, 4.5, 0.75);
        ComplexRefiningManager.addDirtyFuel(oilDense[0], 2, 2.0, 0.75);
        ComplexRefiningManager.addNormalFuel(oilDistilled[0], 10, 3.5, 0.5);
        ComplexRefiningManager.addDirtyFuel(oilHeavy[0], 5, 2.5, 0.5);
        ComplexRefiningManager.addDirtyFuel(crudeOil[0], 4, 3.0, 0.25);
    }

    private static void addBiDirectionalHeatExchange(FluidDefinition[] coldToHot, int amount, int ticks) {
        IComplexRefineryRecipeManager manager = BuildcraftRecipeRegistry.complexRefinery;
        for (int h = 1; h < coldToHot.length; ++h) {
            FluidDefinition cold = coldToHot[h - 1];
            FluidDefinition hot = coldToHot[h];
            manager.addHeatableRecipe(cold.createFluidStack(amount), hot.createFluidStack(amount), h - 1, h, ticks, false);
            manager.addCoolableRecipe(hot.createFluidStack(amount), cold.createFluidStack(amount), h, h - 1, ticks, false);
        }
    }

    private static void addDistilationRecipe(FluidDefinition from, int fromAmount, FluidDefinition gas, int gasAmount, FluidDefinition liquid, int liquidAmount, int ticks) {
        FluidStack in = from.createFluidStack(fromAmount);
        FluidStack outGas = gas.createFluidStack(gasAmount);
        FluidStack outLiquid = liquid.createFluidStack(liquidAmount);
        BuildcraftRecipeRegistry.complexRefinery.addDistilationRecipe(in, outGas, outLiquid, ticks, false);
    }

    private static void addNormalFuel(FluidDefinition def, int amountDiff, double multiplier, double efficiencyMultiplier) {
        int powerBase = 10;
        int timeBase = 256000;
        int powerPerCycle = (int)(multiplier * 10.0);
        int totalTime = (int)(256000.0 * efficiencyMultiplier / multiplier / (double)amountDiff);
        BuildcraftFuelRegistry.fuel.addFuel(def.fluid, powerPerCycle, totalTime);
    }

    private static void addDirtyFuel(FluidDefinition def, int amountDiff, double multiplier, double efficiencyMultiplier) {
        int powerBase = 10;
        int timeBase = 256000;
        int powerPerCycle = (int)(multiplier * 10.0);
        int totalTime = (int)(256000.0 * efficiencyMultiplier / multiplier / (double)amountDiff);
        BuildcraftFuelRegistry.fuel.addDirtyFuel(def.fluid, powerPerCycle, totalTime, oilResidue[0].createFluidStack(1000 / amountDiff));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelBakeEvent event) {
        for (FluidDefinition def : allFluids) {
            ModelFluid model = new ModelFluid((Fluid)def.fluid);
            IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            ModelResourceLocation loc = ModelHelper.getBlockResourceLocation((Block)def.block);
            event.modelRegistry.func_82595_a((Object)loc, (Object)baked);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void textureStitchPre(TextureStitchEvent.Pre event) {
        for (FluidDefinition def : allFluids) {
            int heat = def.fluid.getHeatValue();
            String from = "buildcraftenergy:blocks/fluids/heat_" + heat;
            SpriteColourMapper mapper = new SpriteColourMapper(def.fluid, from + "_still", true);
            event.map.setTextureEntry(def.fluid.getStill().toString(), (TextureAtlasSprite)mapper);
            mapper = new SpriteColourMapper(def.fluid, from + "_flow", false);
            event.map.setTextureEntry(def.fluid.getFlowing().toString(), (TextureAtlasSprite)mapper);
        }
    }

    static {
        allFluids = new ArrayList<FluidDefinition>();
    }
}

