/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.refining;

import buildcraft.api.recipes.IComplexRefineryRecipeManager;
import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fluids.FluidStack;

public enum ComplexRefineryRecipeManager implements IComplexRefineryRecipeManager
{
    INSTANCE;

    private final ComplexRefineryRegistry<IComplexRefineryRecipeManager.IHeatableRecipe> heatableRegistry = new ComplexRefineryRegistry();
    private final ComplexRefineryRegistry<IComplexRefineryRecipeManager.ICoolableRecipe> coolantRegistry = new ComplexRefineryRegistry();
    private final ComplexRefineryRegistry<IComplexRefineryRecipeManager.IDistilationRecipe> distillationRegistry = new ComplexRefineryRegistry();

    @Override
    public IComplexRefineryRecipeManager.IHeatableRecipe createHeatingRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo, int ticks) {
        return new HeatableRecipe(ticks, in, out, heatFrom, heatTo);
    }

    @Override
    public IComplexRefineryRecipeManager.IHeatableRecipe addHeatableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo, int ticks, boolean replaceExisting) {
        return this.getHeatableRegistry().addRecipe(this.createHeatingRecipe(in, out, heatFrom, heatTo, ticks), replaceExisting);
    }

    @Override
    public IComplexRefineryRecipeManager.ICoolableRecipe createCoolableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo, int ticks) {
        return new CoolableRecipe(ticks, in, out, heatFrom, heatTo);
    }

    @Override
    public IComplexRefineryRecipeManager.ICoolableRecipe addCoolableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo, int ticks, boolean replaceExisting) {
        return this.getCoolableRegistry().addRecipe(this.createCoolableRecipe(in, out, heatFrom, heatTo, ticks), replaceExisting);
    }

    @Override
    public IComplexRefineryRecipeManager.IDistilationRecipe createDistilationRecipe(FluidStack in, FluidStack outGas, FluidStack outLiquid, int ticks) {
        return new DistilationRecipe(in, ticks, outGas, outLiquid);
    }

    @Override
    public IComplexRefineryRecipeManager.IDistilationRecipe addDistilationRecipe(FluidStack in, FluidStack outGas, FluidStack outLiquid, int ticks, boolean replaceExisting) {
        return this.getDistilationRegistry().addRecipe(this.createDistilationRecipe(in, outGas, outLiquid, ticks), replaceExisting);
    }

    @Override
    public IComplexRefineryRecipeManager.IComplexRefineryRegistry<IComplexRefineryRecipeManager.IHeatableRecipe> getHeatableRegistry() {
        return this.heatableRegistry;
    }

    @Override
    public IComplexRefineryRecipeManager.IComplexRefineryRegistry<IComplexRefineryRecipeManager.ICoolableRecipe> getCoolableRegistry() {
        return this.coolantRegistry;
    }

    @Override
    public IComplexRefineryRecipeManager.IComplexRefineryRegistry<IComplexRefineryRecipeManager.IDistilationRecipe> getDistilationRegistry() {
        return this.distillationRegistry;
    }

    public static class DistilationRecipe
    extends ComplexRefineryRecipe
    implements IComplexRefineryRecipeManager.IDistilationRecipe {
        private final FluidStack outGas;
        private final FluidStack outLiquid;

        public DistilationRecipe(FluidStack in, int ticks, FluidStack outGas, FluidStack outLiquid) {
            super(in, ticks);
            this.outGas = outGas;
            this.outLiquid = outLiquid;
        }

        @Override
        public FluidStack outGas() {
            return this.outGas;
        }

        @Override
        public FluidStack outLiquid() {
            return this.outLiquid;
        }
    }

    public static class CoolableRecipe
    extends HeatExchangerRecipe
    implements IComplexRefineryRecipeManager.ICoolableRecipe {
        public CoolableRecipe(int ticks, FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(ticks, in, out, heatFrom, heatTo);
            if (heatFrom <= heatTo) {
                throw new IllegalArgumentException("Tried to add a coolant recipe from a lower heat value to a higher one!");
            }
        }
    }

    public static class HeatableRecipe
    extends HeatExchangerRecipe
    implements IComplexRefineryRecipeManager.IHeatableRecipe {
        public HeatableRecipe(int ticks, FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(ticks, in, out, heatFrom, heatTo);
            if (heatFrom >= heatTo) {
                throw new IllegalArgumentException("Tried to add a heatable recipe from a higher heat value to a lower one!");
            }
        }
    }

    public static abstract class HeatExchangerRecipe
    extends ComplexRefineryRecipe
    implements IComplexRefineryRecipeManager.IHeatExchangerRecipe {
        private final FluidStack out;
        private final int heatFrom;
        private final int heatTo;

        public HeatExchangerRecipe(int ticks, FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(in, ticks);
            this.out = out;
            this.heatFrom = heatFrom;
            this.heatTo = heatTo;
        }

        @Override
        public FluidStack out() {
            return this.out;
        }

        @Override
        public int heatFrom() {
            return this.heatFrom;
        }

        @Override
        public int heatTo() {
            return this.heatTo;
        }
    }

    private static abstract class ComplexRefineryRecipe
    implements IComplexRefineryRecipeManager.IComplexRefineryRecipe {
        private final int ticks;
        private final FluidStack in;

        public ComplexRefineryRecipe(FluidStack in, int ticks) {
            this.in = in;
            this.ticks = ticks;
        }

        @Override
        public FluidStack in() {
            return this.in;
        }

        @Override
        public int ticks() {
            return this.ticks;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.in().equals((Object)((IComplexRefineryRecipeManager.IComplexRefineryRecipe)obj).in());
        }

        public int hashCode() {
            return this.in().hashCode();
        }
    }

    private static class ComplexRefineryRegistry<R extends IComplexRefineryRecipeManager.IComplexRefineryRecipe>
    implements IComplexRefineryRecipeManager.IComplexRefineryRegistry<R> {
        private final Set<R> recipeSet = new HashSet<R>();

        private ComplexRefineryRegistry() {
        }

        @Override
        public R addRecipe(R recipe, boolean replaceExisting) {
            if (recipe == null) {
                throw new NullPointerException("recipe");
            }
            IComplexRefineryRecipeManager.IComplexRefineryRecipe existing = this.recipeSet.stream().filter(r -> r.equals(recipe)).findAny().orElse(null);
            if (existing == null) {
                this.recipeSet.add(recipe);
                return recipe;
            }
            if (replaceExisting) {
                this.recipeSet.remove(existing);
                this.recipeSet.add(recipe);
                return recipe;
            }
            return (R)existing;
        }

        @Override
        public Set<R> getAllRecipes() {
            return this.getRecipes(o -> true);
        }

        @Override
        public R getRecipeForInput(FluidStack fluid) {
            return (R)((IComplexRefineryRecipeManager.IComplexRefineryRecipe)this.getRecipesAsStream(f -> f.in().isFluidEqual(fluid)).findAny().orElse(null));
        }

        @Override
        public Set<R> getRecipes(Predicate<R> toReturn) {
            return this.getRecipesAsStream(toReturn).collect(Collectors.toCollection(HashSet::new));
        }

        public Stream<R> getRecipesAsStream(Predicate<R> toReturn) {
            return this.recipeSet.stream().filter(r -> toReturn.apply(r));
        }

        @Override
        public Set<R> removeRecipes(Predicate<R> toRemove) {
            Set<R> removeSet = this.getRecipes(toRemove);
            this.recipeSet.removeAll(removeSet);
            return removeSet;
        }
    }
}

