/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.factory.gui.ContainerEnergyHeater;
import buildcraft.factory.tile.TileEnergyHeater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiEnergyHeater
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/energy_heater.png");
    private final TileEnergyHeater heater;
    private int inTicks;
    private int outTicks;
    private int energyTicks;
    private int craftTicks;

    public GuiEnergyHeater(EntityPlayer player, TileEnergyHeater heater) {
        super(new ContainerEnergyHeater(player, heater), heater, TEXTURE);
        this.heater = heater;
        this.field_146999_f = 176;
        this.field_147000_g = 144;
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.inTicks;
        --this.outTicks;
        --this.energyTicks;
        --this.craftTicks;
        boolean crafted = this.heater.hasCraftedRecently();
        if (crafted) {
            this.craftTicks = 20;
        }
        if (this.heater.getInputTank().getFluid() != null && this.heater.getInputTank().getFluidAmount() > 0 || crafted) {
            this.inTicks = 20;
        }
        if (this.heater.getOutputTank().getFluid() != null && this.heater.getOutputTank().getFluidAmount() > 0 || crafted) {
            this.outTicks = 20;
        }
        if (this.heater.hasEnergy()) {
            this.energyTicks = 20;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(f, mouseX, mouseY);
        if (this.heater != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
            int state = 0;
            if (this.craftTicks > 0) {
                state = 8;
            } else {
                if (this.energyTicks > 0) {
                    state |= 1;
                }
                if (this.inTicks > 0) {
                    state |= 4;
                }
                if (this.outTicks > 0) {
                    state |= 2;
                }
            }
            int y = state * 19;
            this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 20, 176, y, 54, 19);
        }
    }
}

