/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.statements;

import buildcraft.api.enums.EnumEnergyStage;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerEngineHeat
extends BCStatement
implements ITriggerExternal {
    public EnumEnergyStage stage;

    public TriggerEngineHeat(EnumEnergyStage stage) {
        super("buildcraft:engine.stage." + stage.name().toLowerCase(Locale.ROOT), "buildcraft.engine.stage." + stage.name().toLowerCase(Locale.ROOT));
        this.setBuildCraftLocation("energy", "triggers/trigger_engineheat_" + stage.name().toLowerCase(Locale.ROOT));
        this.stage = stage;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.engine." + this.stage.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer container, IStatementParameter[] parameters) {
        if (tile instanceof TileEngineBase) {
            TileEngineBase engine = (TileEngineBase)tile;
            return engine.getEnergyStage() == this.stage;
        }
        return false;
    }
}

