/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.fuels;

import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class FuelManager
implements IFuelManager {
    public static final FuelManager INSTANCE = new FuelManager();
    private final List<IFuel> fuels = new LinkedList<IFuel>();

    private FuelManager() {
    }

    @Override
    public IFuel addFuel(IFuel fuel) {
        this.fuels.add(fuel);
        return fuel;
    }

    @Override
    public IFuel addFuel(Fluid fluid, int powerPerCycle, int totalBurningTime) {
        return this.addFuel(new BCFuel(fluid, powerPerCycle, totalBurningTime));
    }

    @Override
    public IFuelManager.IDirtyFuel addDirtyFuel(Fluid fuel, int powerPerCycle, int totalBurningTime, FluidStack residue) {
        BCDirtyFuel dirty = new BCDirtyFuel(fuel, powerPerCycle, totalBurningTime, residue);
        this.addFuel(dirty);
        return dirty;
    }

    @Override
    public Collection<IFuel> getFuels() {
        return this.fuels;
    }

    @Override
    public IFuel getFuel(Fluid fluid) {
        for (IFuel fuel : this.fuels) {
            if (fuel.getFluid() != fluid) continue;
            return fuel;
        }
        return null;
    }

    private static class BCDirtyFuel
    extends BCFuel
    implements IFuelManager.IDirtyFuel {
        private final FluidStack residue;

        public BCDirtyFuel(Fluid fluid, int powerPerCycle, int totalBurningTime, FluidStack residue) {
            super(fluid, powerPerCycle, totalBurningTime);
            this.residue = residue.copy();
        }

        @Override
        public FluidStack getResidue() {
            return this.residue.copy();
        }
    }

    private static class BCFuel
    implements IFuel {
        private final Fluid fluid;
        private final int powerPerCycle;
        private final int totalBurningTime;

        public BCFuel(Fluid fluid, int powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        @Override
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public int getTotalBurningTime() {
            return this.totalBurningTime;
        }

        @Override
        public int getPowerPerCycle() {
            return this.powerPerCycle;
        }
    }
}

