/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet.manager;

import buildcraft.core.tablet.TabletServer;
import buildcraft.core.tablet.manager.TabletThread;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public enum TabletManagerServer {
    INSTANCE;

    private HashMap<EntityPlayer, TabletThread> threads = new HashMap();

    public TabletServer get(EntityPlayer player) {
        if (!this.threads.containsKey(player)) {
            TabletServer tablet = new TabletServer(player);
            TabletThread thread = new TabletThread(tablet);
            this.threads.put(player, thread);
            new Thread((Runnable)thread, "BuildCraft Tablet Manager").start();
        }
        return (TabletServer)this.threads.get(player).getTablet();
    }

    public void onServerStopping() {
        for (TabletThread thread : this.threads.values()) {
            thread.stop();
        }
        this.threads.clear();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        for (TabletThread thread : this.threads.values()) {
            thread.tick(0.05f);
        }
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TabletThread thread = this.threads.get(event.player);
        if (thread != null) {
            thread.stop();
            this.threads.remove(event.player);
        }
    }
}

