/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.tablet.TabletBase;
import buildcraft.core.tablet.TabletServer;
import buildcraft.core.tablet.manager.TabletManagerClient;
import buildcraft.core.tablet.manager.TabletManagerServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketTabletMessage
extends Packet {
    private NBTTagCompound tag;
    private int playerId;

    public PacketTabletMessage() {
        this.tag = new NBTTagCompound();
    }

    public PacketTabletMessage(NBTTagCompound tag, EntityPlayer player) {
        super(player.field_70170_p);
        this.tag = tag;
        this.playerId = player.func_145782_y();
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.playerId = data.readInt();
        int length = data.readUnsignedShort();
        byte[] compressed = new byte[length];
        data.readBytes(compressed);
        this.tag = NetworkUtils.readNBT(data);
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeInt(this.playerId);
        int index = data.writerIndex();
        NetworkUtils.writeNBT(data, this.tag);
        index = data.writerIndex() - index;
        if (index > 65535) {
            BCLog.logger.error("NBT data is too large (" + index + " > 65,535)! Please report!");
        }
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            TabletBase tablet = TabletManagerClient.INSTANCE.get().getTablet();
            tablet.receiveMessage(this.getTag());
        } else {
            Entity playerById = world.func_73045_a(this.playerId);
            if (playerById instanceof EntityPlayer) {
                TabletServer tablet = TabletManagerServer.INSTANCE.get((EntityPlayer)playerById);
                ((TabletBase)tablet).receiveMessage(this.getTag());
            }
        }
    }
}

