/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.BCStringUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatementParameterDirection
implements IStatementParameter {
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite[] sprites;
    @Nullable
    private EnumFacing direction = null;

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(TextureMap map) {
        sprites = new TextureAtlasSprite[6];
        StatementParameterDirection.sprites[0] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_down"));
        StatementParameterDirection.sprites[1] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_up"));
        StatementParameterDirection.sprites[2] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_north"));
        StatementParameterDirection.sprites[3] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_south"));
        StatementParameterDirection.sprites[4] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_west"));
        StatementParameterDirection.sprites[5] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_east"));
    }

    @Nullable
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon() {
        EnumFacing dir = this.getDirection();
        if (dir == null) {
            return null;
        }
        return sprites[dir.ordinal()];
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        EnumFacing direction = this.getDirection();
        if (source.getTile() instanceof IPipeTile) {
            for (int i = 0; i < 6; ++i) {
                int ord = direction == null ? 0 : direction.ordinal() + (mouse.getButton() > 0 ? -1 : 1);
                direction = EnumFacing.field_82609_l[ord % 6];
                if (!((IPipeTile)source.getTile()).isPipeConnected(this.getDirection())) continue;
                return;
            }
            direction = null;
        }
        this.direction = direction;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.direction != null) {
            nbt.func_74774_a("direction", (byte)this.direction.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.direction = nbt.func_74764_b("direction") ? EnumFacing.field_82609_l[nbt.func_74771_c("direction")] : null;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterDirection) {
            StatementParameterDirection param = (StatementParameterDirection)object;
            return param.getDirection() == this.getDirection();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getDirection());
    }

    @Override
    public String getDescription() {
        EnumFacing dir = this.getDirection();
        if (dir == null) {
            return "";
        }
        return BCStringUtils.localize("direction." + dir.name().toLowerCase());
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeActionDirection";
    }

    @Override
    public IStatementParameter rotateLeft() {
        StatementParameterDirection d = new StatementParameterDirection();
        EnumFacing dir = d.getDirection();
        if (dir != null && dir.func_176740_k() != EnumFacing.Axis.Y) {
            d.direction = dir.func_176746_e();
        }
        return d;
    }
}

