/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCStatement
implements IStatement {
    protected final String uniqueTag;
    private ResourceLocation location;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;

    public BCStatement(String ... uniqueTag) {
        this.uniqueTag = uniqueTag[0];
        for (String tag : uniqueTag) {
            StatementManager.statements.put(tag, this);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public int maxParameters() {
        return 0;
    }

    @Override
    public int minParameters() {
        return 0;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public IStatement rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return null;
    }

    protected void setLocation(String newLocation) {
        this.location = new ResourceLocation(newLocation);
    }

    protected void setBuildCraftLocation(String modulePart, String newLocation) {
        this.setLocation("buildcraft" + modulePart + ":" + newLocation);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stitchTextures(TextureStitchEvent.Pre event) {
        this.sprite = null;
        this.sprite = event.map.getTextureExtry(this.location.toString());
        if (this.sprite == null) {
            this.sprite = event.map.func_174942_a(this.location);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGuiSprite() {
        return this.sprite;
    }
}

