/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.filters.ArrayStackFilter;
import buildcraft.core.recipes.FakeFlexibleCrafter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FlexibleRecipe<T>
implements IFlexibleRecipe<T>,
IFlexibleRecipeViewable {
    public int energyCost = 0;
    public long craftingTime = 0L;
    public String id;
    public T output = null;
    public ArrayList<ItemStack> inputItems = new ArrayList();
    public ArrayList<List<ItemStack>> inputItemsWithAlternatives = new ArrayList();
    public ArrayList<FluidStack> inputFluids = new ArrayList();

    public FlexibleRecipe() {
    }

    public FlexibleRecipe(String id, T output, int iEnergyCost, long craftingTime, Object ... input) {
        this.setContents(id, output, iEnergyCost, craftingTime, input);
    }

    public void setContents(String iid, Object ioutput, int iEnergyCost, long iCraftingTime, Object ... input) {
        this.id = iid;
        if (ioutput == null) {
            throw new IllegalArgumentException("The output of FlexibleRecipe " + iid + " is null! Rejecting recipe.");
        }
        if (ioutput instanceof ItemStack) {
            this.output = ioutput;
        } else if (ioutput instanceof Item) {
            this.output = new ItemStack((Item)ioutput);
        } else if (ioutput instanceof Block) {
            this.output = new ItemStack((Block)ioutput);
        } else if (ioutput instanceof FluidStack) {
            this.output = ioutput;
        } else {
            throw new IllegalArgumentException("An unknown object passed to recipe " + iid + " as output! (" + ioutput.getClass() + ")");
        }
        this.energyCost = iEnergyCost;
        this.craftingTime = iCraftingTime;
        for (Object i : input) {
            if (i == null) {
                throw new IllegalArgumentException("An input of FlexibleRecipe " + iid + " is null! Rejecting recipe.");
            }
            if (i instanceof ItemStack) {
                this.inputItems.add((ItemStack)i);
                continue;
            }
            if (i instanceof Item) {
                this.inputItems.add(new ItemStack((Item)i));
                continue;
            }
            if (i instanceof Block) {
                this.inputItems.add(new ItemStack((Block)i));
                continue;
            }
            if (i instanceof FluidStack) {
                this.inputFluids.add((FluidStack)i);
                continue;
            }
            if (i instanceof List) {
                this.inputItemsWithAlternatives.add((List)i);
                continue;
            }
            if (i instanceof String) {
                this.inputItemsWithAlternatives.add(OreDictionary.getOres((String)((String)i)));
                continue;
            }
            throw new IllegalArgumentException("An unknown object passed to recipe " + iid + " as input! (" + i.getClass() + ")");
        }
    }

    @Override
    public boolean canBeCrafted(IFlexibleCrafter crafter) {
        return this.craft(crafter, true) != null;
    }

    @Override
    public CraftingResult<T> craft(IFlexibleCrafter baseCrafter, boolean preview) {
        int amount;
        ArrayStackFilter filter;
        if (this.output == null) {
            return null;
        }
        IFlexibleCrafter crafter = baseCrafter;
        if (preview) {
            crafter = new FakeFlexibleCrafter(baseCrafter);
        }
        CraftingResult result = new CraftingResult();
        result.recipe = this;
        result.energyCost = this.energyCost;
        result.craftingTime = this.craftingTime;
        for (ItemStack itemStack : this.inputItems) {
            filter = new ArrayStackFilter(itemStack);
            if (this.consumeItems(crafter, result, filter, amount = itemStack.field_77994_a) == 0) continue;
            return null;
        }
        for (List list : this.inputItemsWithAlternatives) {
            filter = new ArrayStackFilter(list.toArray(new ItemStack[list.size()]));
            if (this.consumeItems(crafter, result, filter, amount = ((ItemStack)list.get((int)0)).field_77994_a) == 0) continue;
            return null;
        }
        for (FluidStack fluidStack : this.inputFluids) {
            int amount2 = fluidStack.amount;
            for (int tankid = 0; tankid < crafter.getCraftingFluidStackSize(); ++tankid) {
                FluidStack fluid = crafter.getCraftingFluidStack(tankid);
                if (fluid != null && fluid.isFluidEqual(fluidStack)) {
                    int amountUsed;
                    if (fluid.amount > amount2) {
                        amountUsed = amount2;
                        if (!preview) {
                            crafter.decrCraftingFluidStack(tankid, amount2);
                        }
                        amount2 = 0;
                    } else {
                        amountUsed = fluid.amount;
                        if (!preview) {
                            crafter.decrCraftingFluidStack(tankid, fluid.amount);
                        }
                        amount2 -= fluid.amount;
                    }
                    result.usedFluids.add(new FluidStack(fluidStack.getFluid(), amountUsed));
                }
                if (amount2 == 0) break;
            }
            if (amount2 == 0) continue;
            return null;
        }
        result.crafted = this.output;
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private int consumeItems(IFlexibleCrafter crafter, CraftingResult<T> result, IStackFilter filter, int amount) {
        int expected = amount;
        for (int slotid = 0; slotid < crafter.getCraftingItemStackSize(); ++slotid) {
            ItemStack stack = crafter.getCraftingItemStack(slotid);
            if (stack != null && filter.matches(stack)) {
                ItemStack removed;
                if (stack.field_77994_a >= expected) {
                    removed = crafter.decrCraftingItemStack(slotid, expected);
                    expected = 0;
                } else {
                    removed = crafter.decrCraftingItemStack(slotid, stack.field_77994_a);
                    expected -= removed.field_77994_a;
                }
                result.usedItems.add(removed);
            }
            if (expected != 0) continue;
            return 0;
        }
        return amount;
    }

    @Override
    public CraftingResult<T> canCraft(ItemStack expectedOutput) {
        if (this.output instanceof ItemStack && StackHelper.isMatchingItem(expectedOutput, (ItemStack)this.output)) {
            CraftingResult result = new CraftingResult();
            result.recipe = this;
            result.usedFluids = this.inputFluids;
            result.usedItems = this.inputItems;
            result.crafted = this.output;
            return result;
        }
        return null;
    }

    @Override
    public Object getOutput() {
        return this.output;
    }

    @Override
    public Collection<Object> getInputs() {
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.addAll(this.inputItems);
        inputs.addAll(this.inputItemsWithAlternatives);
        inputs.addAll(this.inputFluids);
        return inputs;
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public long getCraftingTime() {
        return this.craftingTime;
    }

    private class PreviewCrafter
    implements IFlexibleCrafter {
        private final SimpleInventory inventory;
        private final IFlexibleCrafter crafter;

        public PreviewCrafter(IFlexibleCrafter crafter) {
            this.crafter = crafter;
            this.inventory = new SimpleInventory(crafter.getCraftingItemStackSize(), "Preview", 64);
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack s = crafter.getCraftingItemStack(i);
                if (s == null) continue;
                this.inventory.func_70299_a(i, s.func_77946_l());
            }
        }

        @Override
        public int getCraftingItemStackSize() {
            return this.inventory.func_70302_i_();
        }

        @Override
        public ItemStack getCraftingItemStack(int slotid) {
            return this.inventory.func_70301_a(slotid);
        }

        @Override
        public ItemStack decrCraftingItemStack(int slotid, int val) {
            return this.inventory.func_70298_a(slotid, val);
        }

        @Override
        public FluidStack getCraftingFluidStack(int tankid) {
            return this.crafter.getCraftingFluidStack(tankid);
        }

        @Override
        public FluidStack decrCraftingFluidStack(int tankid, int val) {
            return this.crafter.decrCraftingFluidStack(tankid, val);
        }

        @Override
        public int getCraftingFluidStackSize() {
            return this.crafter.getCraftingFluidStackSize();
        }
    }
}

