/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IAssemblyRecipeManager;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.core.recipes.FlexibleRecipe;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class AssemblyRecipeManager
implements IAssemblyRecipeManager {
    public static final AssemblyRecipeManager INSTANCE = new AssemblyRecipeManager();
    private BiMap<String, IFlexibleRecipe<ItemStack>> assemblyRecipes = HashBiMap.create();

    @Override
    public void addRecipe(String id, int energyCost, ItemStack output, Object ... input) {
        if (output == null) {
            throw new IllegalArgumentException("Cannot have a null output!");
        }
        this.addRecipe(id, new FlexibleRecipe<ItemStack>(id, output, energyCost, 0L, input));
    }

    @Override
    public void addRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.addRecipe(recipe.getId(), recipe);
    }

    private void addRecipe(String id, IFlexibleRecipe<ItemStack> recipe) {
        if (recipe == null) {
            throw new RuntimeException("Recipe \"" + id + "\" is null!");
        }
        if (this.assemblyRecipes.containsKey((Object)id)) {
            throw new RuntimeException("Recipe \"" + id + "\" already registered");
        }
        this.assemblyRecipes.put((Object)recipe.getId(), recipe);
    }

    @Override
    public Collection<IFlexibleRecipe<ItemStack>> getRecipes() {
        return this.assemblyRecipes.values();
    }

    public IFlexibleRecipe<ItemStack> getRecipe(String id) {
        return (IFlexibleRecipe)this.assemblyRecipes.get((Object)id);
    }

    @Override
    public void removeRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.removeRecipe(recipe.getId());
    }

    @Override
    public void removeRecipe(String id) {
        this.assemblyRecipes.remove((Object)id);
    }
}

