/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.properties;

import buildcraft.core.properties.WorldProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class WorldPropertyIsOre
extends WorldProperty {
    private final HashSet<Integer> ores = new HashSet();
    private final int harvestLevel;

    public WorldPropertyIsOre(int harvestLevel) {
        this.initBlockHarvestTools();
        this.harvestLevel = harvestLevel;
        for (String oreName : OreDictionary.getOreNames()) {
            IBlockState state;
            Block block;
            List oreStacks;
            if (!oreName.startsWith("ore") || (oreStacks = OreDictionary.getOres((String)oreName)).size() <= 0 || (block = Block.func_149634_a((Item)((ItemStack)oreStacks.get(0)).func_77973_b())) == null) continue;
            int meta = ((ItemStack)oreStacks.get(0)).func_77952_i();
            if (meta >= 16 || meta < 0) {
                meta = 0;
            }
            if (!"pickaxe".equals(block.getHarvestTool(state = block.func_176203_a(meta))) || block.getHarvestLevel(state) > harvestLevel) continue;
            this.ores.add(OreDictionary.getOreID((String)oreName));
        }
    }

    private void initBlockHarvestTools() {
        new ForgeHooks();
    }

    @Override
    public boolean get(IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == null) {
            return false;
        }
        if (state.func_177230_c() == Blocks.field_150439_ay) {
            return block.getHarvestLevel(state) <= this.harvestLevel;
        }
        ArrayList<ItemStack> toCheck = new ArrayList<ItemStack>();
        toCheck.add(new ItemStack(block, 1, block.func_176201_c(state)));
        if (block.hasTileEntity(state) && blockAccess instanceof World) {
            toCheck.addAll(block.getDrops((IBlockAccess)((World)blockAccess), pos, state, 0));
        }
        for (ItemStack stack : toCheck) {
            if (stack.func_77973_b() == null) continue;
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!this.ores.contains(id)) continue;
                return true;
            }
        }
        return false;
    }
}

