/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IZone;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.IIterableAlgorithm;
import buildcraft.core.lib.utils.PathFinding;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class PathFindingSearch
implements IIterableAlgorithm {
    public static final int PATH_ITERATIONS = 1000;
    private static final HashMap<Integer, HashSet<BlockPos>> reservations = new HashMap();
    private World world;
    private BlockPos start;
    private List<PathFinding> pathFinders;
    private IBlockFilter pathFound;
    private IZone zone;
    private float maxDistance;
    private Iterator<BlockPos> blockIter;
    private double maxDistanceToEnd;

    public PathFindingSearch(World iWorld, BlockPos iStart, Iterator<BlockPos> iBlockIter, IBlockFilter iPathFound, double iMaxDistanceToEnd, float iMaxDistance, IZone iZone) {
        this.world = iWorld;
        this.start = iStart;
        this.pathFound = iPathFound;
        this.maxDistance = iMaxDistance;
        this.maxDistanceToEnd = iMaxDistanceToEnd;
        this.zone = iZone;
        this.blockIter = iBlockIter;
        this.pathFinders = new LinkedList<PathFinding>();
    }

    @Override
    public void iterate() {
        if (this.pathFinders.size() < 5 && this.blockIter.hasNext()) {
            this.iterateSearch(10000);
        }
        this.iteratePathFind(1000);
    }

    private void iterateSearch(int itNumber) {
        for (int i = 0; i < itNumber; ++i) {
            if (!this.blockIter.hasNext()) {
                return;
            }
            BlockPos delta = this.blockIter.next();
            BlockPos block = new BlockPos(this.start.func_177958_n() + delta.func_177958_n(), this.start.func_177956_o() + delta.func_177956_o() > 0 ? this.start.func_177956_o() + delta.func_177956_o() : 0, this.start.func_177952_p() + delta.func_177952_p());
            if (this.isLoadedChunk(block.func_177958_n(), block.func_177952_p()) && this.isTarget(block)) {
                this.pathFinders.add(new PathFinding(this.world, this.start, block, this.maxDistanceToEnd, this.maxDistance));
            }
            if (this.pathFinders.size() < 5) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTarget(BlockPos block) {
        if (this.zone != null && !this.zone.contains(Utils.convert((Vec3i)block))) {
            return false;
        }
        if (!this.pathFound.matches(this.world, block)) {
            return false;
        }
        HashMap<Integer, HashSet<BlockPos>> hashMap = reservations;
        synchronized (hashMap) {
            HashSet<BlockPos> dimReservations;
            if (reservations.containsKey(this.world.field_73011_w.func_177502_q()) && (dimReservations = reservations.get(this.world.field_73011_w.func_177502_q())).contains(block)) {
                return false;
            }
        }
        return BuildCraftAPI.isSoftBlock(this.world, block.func_177976_e()) || BuildCraftAPI.isSoftBlock(this.world, block.func_177974_f()) || BuildCraftAPI.isSoftBlock(this.world, block.func_177978_c()) || BuildCraftAPI.isSoftBlock(this.world, block.func_177968_d()) || BuildCraftAPI.isSoftBlock(this.world, block.func_177977_b()) || BuildCraftAPI.isSoftBlock(this.world, block.func_177984_a());
    }

    private boolean isLoadedChunk(int x, int z) {
        return this.world.func_72863_F().func_73149_a(x >> 4, z >> 4);
    }

    public void iteratePathFind(int itNumber) {
        for (PathFinding pathFinding : new ArrayList<PathFinding>(this.pathFinders)) {
            pathFinding.iterate(itNumber / this.pathFinders.size());
            if (!pathFinding.isDone()) continue;
            LinkedList<BlockPos> path = pathFinding.getResult();
            if (path != null && path.size() > 0 && this.reserve(pathFinding.end())) {
                return;
            }
            this.pathFinders.remove(pathFinding);
        }
    }

    @Override
    public boolean isDone() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return true;
        }
        return !this.blockIter.hasNext();
    }

    public LinkedList<BlockPos> getResult() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return pathFinding.getResult();
        }
        return new LinkedList<BlockPos>();
    }

    public BlockPos getResultTarget() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return pathFinding.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserve(BlockPos block) {
        HashMap<Integer, HashSet<BlockPos>> hashMap = reservations;
        synchronized (hashMap) {
            HashSet<BlockPos> dimReservations;
            if (!reservations.containsKey(this.world.field_73011_w.func_177502_q())) {
                reservations.put(this.world.field_73011_w.func_177502_q(), new HashSet());
            }
            if ((dimReservations = reservations.get(this.world.field_73011_w.func_177502_q())).contains(block)) {
                return false;
            }
            dimReservations.add(block);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreserve(BlockPos block) {
        HashMap<Integer, HashSet<BlockPos>> hashMap = reservations;
        synchronized (hashMap) {
            if (reservations.containsKey(this.world.field_73011_w.func_177502_q())) {
                reservations.get(this.world.field_73011_w.func_177502_q()).remove(block);
            }
        }
    }
}

