/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IWorldProperty;
import buildcraft.core.lib.utils.IIterableAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class PathFinding
implements IIterableAlgorithm {
    private static IWorldProperty FREE_FOR_PATH = BuildCraftAPI.getWorldProperty("freepath");
    public static int PATH_ITERATIONS = 1000;
    private World world;
    private BlockPos start;
    private BlockPos end;
    private double maxDistanceToEndSq = 0.0;
    private float maxTotalDistanceSq = 0.0f;
    private HashMap<BlockPos, Node> openList = new HashMap();
    private HashMap<BlockPos, Node> closedList = new HashMap();
    private Node nextIteration;
    private LinkedList<BlockPos> result;
    private boolean endReached = false;

    public PathFinding(World iWorld, BlockPos iStart, BlockPos iEnd) {
        this.world = iWorld;
        this.start = iStart;
        this.end = iEnd;
        Node startNode = new Node();
        startNode.parent = null;
        startNode.movementCost = 0.0;
        startNode.destinationCost = PathFinding.distanceSq(this.start, this.end);
        startNode.totalWeight = startNode.movementCost + startNode.destinationCost;
        startNode.index = iStart;
        this.openList.put(this.start, startNode);
        this.nextIteration = startNode;
    }

    public PathFinding(World iWorld, BlockPos iStart, BlockPos iEnd, double iMaxDistanceToEnd) {
        this(iWorld, iStart, iEnd);
        this.maxDistanceToEndSq = iMaxDistanceToEnd * iMaxDistanceToEnd;
    }

    public PathFinding(World iWorld, BlockPos iStart, BlockPos iEnd, double iMaxDistanceToEnd, float iMaxTotalDistance) {
        this(iWorld, iStart, iEnd, iMaxDistanceToEnd);
        this.maxTotalDistanceSq = iMaxTotalDistance * iMaxTotalDistance;
    }

    @Override
    public void iterate() {
        this.iterate(PATH_ITERATIONS);
    }

    public void iterate(int itNumber) {
        for (int i = 0; i < itNumber; ++i) {
            if (this.nextIteration == null) {
                return;
            }
            if (this.endReached) {
                this.result = new LinkedList();
                while (this.nextIteration != null) {
                    this.result.addFirst(this.nextIteration.index);
                    this.nextIteration = this.nextIteration.parent;
                }
                return;
            }
            this.nextIteration = this.iterate(this.nextIteration);
        }
    }

    @Override
    public boolean isDone() {
        return this.nextIteration == null;
    }

    public LinkedList<BlockPos> getResult() {
        if (this.result != null) {
            return this.result;
        }
        return new LinkedList<BlockPos>();
    }

    public BlockPos end() {
        return this.end;
    }

    private Node iterate(Node from) {
        this.openList.remove(from.index);
        this.closedList.put(from.index, from);
        ArrayList<Node> nodes = new ArrayList<Node>();
        byte[][][] resultMoves = this.movements(from);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (resultMoves[dx + 1][dy + 1][dz + 1] == 0) continue;
                    int x = from.index.func_177958_n() + dx;
                    int y = from.index.func_177956_o() + dy;
                    int z = from.index.func_177952_p() + dz;
                    Node nextNode = new Node();
                    nextNode.parent = from;
                    nextNode.index = new BlockPos(x, y, z);
                    if (resultMoves[dx + 1][dy + 1][dz + 1] == 2) {
                        this.endReached = true;
                        return nextNode;
                    }
                    nextNode.movementCost = from.movementCost + PathFinding.distanceSq(nextNode.index, from.index);
                    nextNode.destinationCost = PathFinding.distanceSq(nextNode.index, this.end);
                    nextNode.totalWeight = nextNode.movementCost + nextNode.destinationCost;
                    if (this.maxTotalDistanceSq > 0.0f && nextNode.totalWeight > (double)this.maxTotalDistanceSq) {
                        if (this.closedList.containsKey(nextNode.index)) continue;
                        this.closedList.put(nextNode.index, nextNode);
                        continue;
                    }
                    if (this.closedList.containsKey(nextNode.index)) continue;
                    if (this.openList.containsKey(nextNode.index)) {
                        Node tentative = this.openList.get(nextNode.index);
                        if (tentative.movementCost < nextNode.movementCost) {
                            nextNode = tentative;
                        } else {
                            this.openList.put(nextNode.index, nextNode);
                        }
                    } else {
                        this.openList.put(nextNode.index, nextNode);
                    }
                    nodes.add(nextNode);
                }
            }
        }
        nodes.addAll(this.openList.values());
        return this.findSmallerWeight(nodes);
    }

    private Node findSmallerWeight(Collection<Node> collection) {
        Node found = null;
        for (Node n : collection) {
            if (found == null) {
                found = n;
                continue;
            }
            if (!(n.totalWeight < found.totalWeight)) continue;
            found = n;
        }
        return found;
    }

    private static double distanceSq(BlockPos i1, BlockPos i2) {
        double dx = (double)i1.func_177958_n() - (double)i2.func_177958_n();
        double dy = (double)i1.func_177956_o() - (double)i2.func_177956_o();
        double dz = (double)i1.func_177952_p() - (double)i2.func_177952_p();
        return dx * dx + dy * dy + dz * dz;
    }

    public static boolean isFreeForPath(World world, BlockPos pos) {
        return FREE_FOR_PATH.get(world, pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean endReached(int x, int y, int z) {
        if (this.maxDistanceToEndSq == 0.0) {
            if (this.end.func_177958_n() != x) return false;
            if (this.end.func_177956_o() != y) return false;
            if (this.end.func_177952_p() != z) return false;
            return true;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!PathFinding.isFreeForPath(this.world, pos)) return false;
        BlockPos blockPos = new BlockPos((Vec3i)pos);
        if (!(PathFinding.distanceSq(blockPos, this.end) <= this.maxDistanceToEndSq)) return false;
        return true;
    }

    private byte[][][] movements(Node from) {
        int j;
        int i;
        byte[][][] resultMoves = new byte[3][3][3];
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int x = from.index.func_177958_n() + dx;
                    int y = from.index.func_177956_o() + dy;
                    int z = from.index.func_177952_p() + dz;
                    resultMoves[dx + 1][dy + 1][dz + 1] = y < 0 ? 0 : (this.endReached(x, y, z) ? 2 : (!PathFinding.isFreeForPath(this.world, new BlockPos(x, y, z)) ? 0 : 1));
                }
            }
        }
        resultMoves[1][1][1] = 0;
        if (resultMoves[0][1][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[0][i][j] = 0;
                }
            }
        }
        if (resultMoves[2][1][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[2][i][j] = 0;
                }
            }
        }
        if (resultMoves[1][0][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][0][j] = 0;
                }
            }
        }
        if (resultMoves[1][2][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][2][j] = 0;
                }
            }
        }
        if (resultMoves[1][1][0] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][j][0] = 0;
                }
            }
        }
        if (resultMoves[1][1][2] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][j][2] = 0;
                }
            }
        }
        if (resultMoves[0][0][1] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[0][0][2] = 0;
        }
        if (resultMoves[0][2][1] == 0) {
            resultMoves[0][2][0] = 0;
            resultMoves[0][2][2] = 0;
        }
        if (resultMoves[2][0][1] == 0) {
            resultMoves[2][0][0] = 0;
            resultMoves[2][0][2] = 0;
        }
        if (resultMoves[2][2][1] == 0) {
            resultMoves[2][2][0] = 0;
            resultMoves[2][2][2] = 0;
        }
        if (resultMoves[0][1][0] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[0][2][0] = 0;
        }
        if (resultMoves[0][1][2] == 0) {
            resultMoves[0][0][2] = 0;
            resultMoves[0][2][2] = 0;
        }
        if (resultMoves[2][1][0] == 0) {
            resultMoves[2][0][0] = 0;
            resultMoves[2][2][0] = 0;
        }
        if (resultMoves[2][1][2] == 0) {
            resultMoves[2][0][2] = 0;
            resultMoves[2][2][2] = 0;
        }
        if (resultMoves[1][0][0] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[2][0][0] = 0;
        }
        if (resultMoves[1][0][2] == 0) {
            resultMoves[0][0][2] = 0;
            resultMoves[2][0][2] = 0;
        }
        if (resultMoves[1][2][0] == 0) {
            resultMoves[0][2][0] = 0;
            resultMoves[2][2][0] = 0;
        }
        if (resultMoves[1][2][2] == 0) {
            resultMoves[0][2][2] = 0;
            resultMoves[2][2][2] = 0;
        }
        return resultMoves;
    }

    private static class Node {
        public Node parent;
        public double movementCost;
        public double destinationCost;
        public double totalWeight;
        public BlockPos index;

        private Node() {
        }
    }
}

