/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public final class ColorUtils {
    private static final int[] WOOL_TO_RGB = new int[]{0xFFFFFF, 14188339, 11685080, 6724056, 0xE5E533, 8375321, 15892389, 0x4C4C4C, 0x999999, 5013401, 8339378, 3361970, 6704179, 6717235, 0x993333, 0x191919};
    private static final String[] WOOL_TO_NAME = new String[]{"white", "orange", "magenta", "light.blue", "yellow", "lime", "pink", "gray", "light.gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] OREDICT_DYE_NAMES = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    private static final int[] LIGHT_HEX = new int[]{0x181414, 12462887, 32526, 8998957, 2437523, 8271039, 0x299799, 0xA0A7A7, 0x7A7A7A, 14250393, 3790126, 16767260, 0x66AAFF, 14238662, 15366197, 0xE4E4E4};
    private static final int[] OREDICT_DYE_IDS = new int[16];
    private static final char[] WOOL_TO_CHAT = new char[]{'f', '6', 'd', '9', 'e', 'a', 'd', '8', '7', '3', '5', '1', '6', '2', '4', '0'};

    private ColorUtils() {
    }

    public static void initialize() {
        for (int i = 0; i < 16; ++i) {
            ColorUtils.OREDICT_DYE_IDS[i] = OreDictionary.getOreID((String)OREDICT_DYE_NAMES[i]);
        }
    }

    public static EnumDyeColor getColorFromDye(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        if (stack.func_77973_b() == Items.field_151100_aR) {
            return EnumDyeColor.func_176766_a((int)stack.func_77952_i());
        }
        int[] itemOreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (int damage = 0; damage < 16; ++damage) {
            for (int id : itemOreIDs) {
                if (OREDICT_DYE_IDS[damage] != id) continue;
                return EnumDyeColor.func_176766_a((int)damage);
            }
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return ColorUtils.getColorFromDye(stack) != null;
    }

    public static int getRGBColor(int wool) {
        return WOOL_TO_RGB[wool & 0xF];
    }

    public static String getName(int wool) {
        return WOOL_TO_NAME[wool & 0xF];
    }

    public static String getOreDictionaryName(int wool) {
        return OREDICT_DYE_NAMES[wool & 0xF];
    }

    public static String getFormatting(int wool) {
        return "\u00a7" + WOOL_TO_CHAT[wool & 0xF];
    }

    public static String getFormattingTooltip(int wool) {
        return "\u00a7" + (WOOL_TO_CHAT[wool & 0xF] == '0' ? (char)'8' : WOOL_TO_CHAT[wool & 0xF]);
    }

    public static int getLightHex(EnumDyeColor color) {
        return LIGHT_HEX[color.func_176765_a()];
    }

    public static int convertBGRAtoRGBA(int argb) {
        int a = argb >>> 24;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return (a << 24) + (b << 16) + (g << 8) + r;
    }

    public static EnumDyeColor next(EnumDyeColor color) {
        int meta = color.func_176765_a() + 1;
        return EnumDyeColor.func_176764_b((int)(meta & 0xF));
    }

    public static EnumDyeColor previous(EnumDyeColor color) {
        int meta = color.func_176765_a() + 15;
        return EnumDyeColor.func_176764_b((int)(meta & 0xF));
    }

    public static String localize(EnumDyeColor color) {
        return StatCollector.func_74838_a((String)color.func_176762_d());
    }
}

