/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.base;

import buildcraft.api.core.BCLog;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.lib.network.base.Packet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@ChannelHandler.Sharable
public final class PacketHandler
extends SimpleChannelInboundHandler<Packet> {
    public static final int INVALID_DIM_ID = -2147483638;
    private static volatile int livePacketCount = 0;
    private static int lastSomethingPackets = 0;
    private static long lastDispMs = System.currentTimeMillis();
    private final Map<Side, Map<Integer, Queue<Packet>>> packetMap;

    public PacketHandler() {
        HashMap map = Maps.newHashMap();
        for (Side side : Side.values()) {
            ConcurrentHashMap mp = new ConcurrentHashMap();
            map.put(side, mp);
        }
        this.packetMap = ImmutableMap.copyOf((Map)map);
        TickHandlerCore.addPacketHandler(this);
    }

    public static int packetQueueSize() {
        long now = System.currentTimeMillis();
        if (now - lastDispMs > 800L) {
            lastDispMs = now;
            lastSomethingPackets = livePacketCount;
            livePacketCount = 0;
        }
        return lastSomethingPackets;
    }

    public void tick(World world) {
        Packet packet = null;
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        int dimId = world.field_73011_w.func_177502_q();
        Queue<Packet> queue = this.getQueue(side, dimId);
        while ((packet = queue.poll()) != null) {
            packet.applyData(world, packet.player);
        }
    }

    public void unload(World world) {
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        int dimId = world.field_73011_w.func_177502_q();
        Queue<Packet> queue = this.getQueue(side, dimId);
        queue.clear();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        Side side = (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get();
        if (packet.dimensionId == -2147483638) {
            BCLog.logger.warn("Found a packet with an invalid dimension id! [read]");
        }
        if (!packet.hasDoneByteStuff) {
            throw new IllegalArgumentException("Tried to use a packet that hasn't read yet! THIS IS VERY BAD!");
        }
        if (side != null) {
            this.getQueue(side, packet.dimensionId).add(packet);
            ++livePacketCount;
        } else {
            BCLog.logger.error("Found a message without a side! THIS IS VERY BAD, MAJOR ERRORS COULD OCCOUR!");
        }
    }

    private Queue<Packet> getQueue(Side side, int dimId) {
        Map<Integer, Queue<Packet>> map = this.packetMap.get(side);
        if (!map.containsKey(dimId)) {
            map.put(dimId, Queues.newConcurrentLinkedQueue());
        }
        return map.get(dimId);
    }
}

