/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.base;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.PacketCoordinates;
import buildcraft.core.lib.network.PacketUpdate;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.base.StatisticsFrame;
import buildcraft.core.lib.network.command.PacketCommand;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NetworkStatRecorder {
    static final Map<String, Integer> lengthMap = Maps.newHashMap();
    static final Map<PacketSource, EnumMap<EnumOpType, PacketStats>> packetMap = new MapMaker().makeMap();

    public static void recordStat(ChannelHandlerContext ctx, long bytes, Packet packet, EnumOpType type) {
        String channelName;
        PacketSource source = new PacketSource(packet);
        if (!packetMap.containsKey(source)) {
            EnumMap map = Maps.newEnumMap(EnumOpType.class);
            map.put(EnumOpType.READ, new PacketStats());
            map.put(EnumOpType.WRITE, new PacketStats());
            packetMap.put(source, map);
        }
        if (!lengthMap.containsKey(channelName = (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get())) {
            lengthMap.put(channelName, new PacketBuffer(Unpooled.buffer()).func_180714_a(channelName).arrayOffset());
        }
        int header = lengthMap.get(channelName);
        EnumMap<EnumOpType, PacketStats> map = packetMap.get(source);
        map.get((Object)type).increment(bytes + (long)header);
    }

    static class PacketSource {
        final Class<? extends Packet> clazz;
        final String className;
        final String extraInfo;
        private final transient int hashCode;

        public static String extraInfo(Packet packet) {
            if (packet instanceof PacketCoordinates) {
                TileEntity tile = ((PacketCoordinates)packet).tile;
                return tile == null ? "generic" : tile.getClass().getName();
            }
            if (packet instanceof PacketUpdate) {
                ISerializable ser = ((PacketUpdate)packet).payload;
                return ser == null ? "generic" : ser.getClass().getName();
            }
            if (packet instanceof PacketCommand) {
                return ((PacketCommand)packet).command;
            }
            return null;
        }

        public PacketSource(Packet packet) {
            this(packet.getClass(), PacketSource.extraInfo(packet));
        }

        public PacketSource(Class<? extends Packet> packet, String extraInfo) {
            if (packet == null) {
                throw new NullPointerException("packet");
            }
            if (extraInfo == null) {
                extraInfo = "unknown";
            }
            this.clazz = packet;
            this.className = packet.getName();
            this.extraInfo = extraInfo;
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.className);
            hcb.append((Object)extraInfo);
            this.hashCode = hcb.toHashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PacketSource other = (PacketSource)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.className, (Object)other.className);
            eb.append((Object)this.extraInfo, (Object)other.extraInfo);
            return eb.isEquals();
        }
    }

    static class PacketStats {
        public static final int HISTORY_SIZE = 120;
        public static final long HISTORY_GAP = 1000L;
        final int[] packets = new int[120];
        final long[] bytes = new long[120];
        final long[] statTime = new long[120];
        int currentIndex = 0;

        private PacketStats() {
            this.statTime[this.currentIndex] = System.currentTimeMillis();
        }

        public void increment(long bytes) {
            int n = this.currentIndex;
            this.packets[n] = this.packets[n] + 1;
            int n2 = this.currentIndex;
            this.bytes[n2] = this.bytes[n2] + bytes;
            this.process();
        }

        private int incrementIndex() {
            ++this.currentIndex;
            if (this.currentIndex >= 120) {
                this.currentIndex = 0;
            }
            return this.currentIndex;
        }

        public int getLastIndex() {
            if (this.currentIndex - 1 < 0) {
                return 119;
            }
            return this.currentIndex - 1;
        }

        private void process() {
            long now = System.currentTimeMillis();
            if (now - this.statTime[this.currentIndex] < 1000L) {
                return;
            }
            this.statTime[this.incrementIndex()] = now;
            this.packets[this.currentIndex] = 0;
            this.bytes[this.currentIndex] = 0L;
            StatisticsFrame.update();
        }
    }

    static enum EnumOpType {
        READ("read", "from"),
        WRITE("wrote", "to");

        final String operation;
        final String word;

        private EnumOpType(String operation, String word) {
            this.operation = operation;
            this.word = word;
        }
    }
}

