/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.ISyncedTile;
import buildcraft.core.lib.network.PacketCoordinates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileState
extends PacketCoordinates {
    private ByteBuf state;
    private List<StateWithId> stateList = new LinkedList<StateWithId>();

    public PacketTileState() {
    }

    public PacketTileState(TileEntity tile) {
        super(tile);
    }

    public void addStateForSerialization(byte stateId, ISerializable state) {
        this.stateList.add(new StateWithId(stateId, state));
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        ByteBuf tmpState = Unpooled.buffer();
        tmpState.writeByte(this.stateList.size());
        for (StateWithId stateWithId : this.stateList) {
            tmpState.writeByte((int)stateWithId.stateId);
            stateWithId.state.writeData(tmpState);
        }
        data.writeShort((int)((short)tmpState.readableBytes()));
        data.writeBytes(tmpState.readBytes(tmpState.readableBytes()));
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.state = Unpooled.buffer();
        int length = data.readUnsignedShort();
        this.state.writeBytes(data.readBytes(length));
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ISyncedTile) {
            ISyncedTile tile1 = (ISyncedTile)tile;
            int stateCount = this.state.readByte();
            for (int i = 0; i < stateCount; ++i) {
                byte stateId = this.state.readByte();
                tile1.getStateInstance(stateId).readData(this.state);
                tile1.afterStateUpdated(stateId);
            }
        } else {
            BCLog.logger.debug("Ignored the packet (" + this.getClass() + ") @ " + this.pos + " as (" + tile + " instanceof ISyncedTile) was false!");
        }
    }

    @Override
    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("PacketTileState [state=");
        builder.append(this.state == null ? "-1" : Integer.valueOf(this.state.readableBytes()));
        builder.append(", stateList=");
        builder.append(this.stateList != null ? this.stateList.subList(0, Math.min(this.stateList.size(), 10)) : null);
        builder.append(", super=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    private class StateWithId {
        public byte stateId;
        public ISerializable state;

        public StateWithId(byte stateId, ISerializable state) {
            this.stateId = stateId;
            this.state = state;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("StateWithId [stateId=");
            builder.append(this.stateId);
            builder.append(", state=");
            builder.append(this.state == null ? "null" : this.state.getClass());
            builder.append("]");
            return builder.toString();
        }
    }
}

