/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.core.lib.network.PacketCoordinates;
import buildcraft.core.lib.utils.NetworkUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketSlotChange
extends PacketCoordinates {
    public int slot;
    public ItemStack stack;

    public PacketSlotChange() {
    }

    public PacketSlotChange(TileEntity tile, int slot, ItemStack stack) {
        super(tile);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeShort(this.slot);
        NetworkUtils.writeStack(data, this.stack);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.slot = data.readUnsignedShort();
        this.stack = NetworkUtils.readStack(data);
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (!world.func_175667_e(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ITile) {
            ((ITile)tile).updateCraftingMatrix(this.slot, this.stack);
        }
    }

    public static interface ITile {
        public void updateCraftingMatrix(int var1, ItemStack var2);
    }
}

