/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.items;

import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.ModelHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBuildCraft
extends Item
implements IModelRegister {
    private boolean passSneakClick = false;
    protected String textureName = null;
    private IItemLocalizationRule localizationRule = null;
    private String[] localizationRuleArray = null;

    public ItemBuildCraft() {
        this(BCCreativeTab.get("main"));
    }

    public ItemBuildCraft(CreativeTabs creativeTab) {
        this.func_77637_a(creativeTab);
    }

    public ItemBuildCraft setTextureLocation(String name) {
        this.textureName = name;
        return this;
    }

    public Item setPassSneakClick(boolean passClick) {
        this.passSneakClick = passClick;
        return this;
    }

    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return this.passSneakClick;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        if (this.textureName == null) {
            ModelHelper.registerItemModel(this, 0, "");
        } else {
            ModelHelper.registerItemModel(this, 0, this.textureName, "");
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.localizationRule == null || this.localizationRuleArray == null) {
            return super.func_77667_c(stack);
        }
        int index = this.localizationRule.getUnlocalizedNameFor(stack);
        if (index < 0 || index >= this.localizationRuleArray.length) {
            return super.func_77667_c(stack);
        }
        return this.localizationRuleArray[index];
    }

    public void setLocalizationRuleArray(String ... strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("Not enough strings!");
        }
        this.localizationRuleArray = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null || strings[i].length() == 0) {
                throw new NullPointerException("strings[" + i + "]");
            }
            this.localizationRuleArray[i] = strings[i];
        }
    }

    public void setLocalizationRule(IItemLocalizationRule rule) {
        if (this.localizationRuleArray == null) {
            throw new IllegalStateException("Must set the array before setting the rule!");
        }
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        int forNull = rule.getUnlocalizedNameFor(null);
        if (forNull < 0 || forNull >= this.localizationRuleArray.length) {
            throw new IllegalStateException("Must return a valid index for null!");
        }
        this.localizationRule = rule;
    }

    public static interface IItemLocalizationRule {
        public int getUnlocalizedNameFor(ItemStack var1);
    }
}

