/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.core.lib.inventory.IItemHandlerDelegate;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerDelegate
implements IItemHandler {
    private final IItemHandler delegate;
    private ToIntFunction<IItemHandler> funcGetSlots;
    private BiFunction<IItemHandler, Integer, ItemStack> funcGetStackInSlot;
    private IItemHandlerDelegate.FunctionInsertItem funcInsertItem;
    private IItemHandlerDelegate.FunctionExtractItem funcExtractItem;

    private ItemHandlerDelegate(IItemHandler delegate) {
        this.delegate = delegate;
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler) {
        if (handler instanceof ItemHandlerDelegate) {
            return (ItemHandlerDelegate)handler;
        }
        return new ItemHandlerDelegate(handler);
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler, ToIntFunction<IItemHandler> funcGetSlots) {
        ItemHandlerDelegate delegate = ItemHandlerDelegate.createFrom(handler);
        delegate.funcGetSlots = funcGetSlots;
        return delegate;
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler, BiFunction<IItemHandler, Integer, ItemStack> funcGetStackInSlot) {
        ItemHandlerDelegate delegate = ItemHandlerDelegate.createFrom(handler);
        delegate.funcGetStackInSlot = funcGetStackInSlot;
        return delegate;
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler, IItemHandlerDelegate.FunctionInsertItem funcInsertItem) {
        ItemHandlerDelegate delegate = ItemHandlerDelegate.createFrom(handler);
        delegate.funcInsertItem = funcInsertItem;
        return delegate;
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler, IItemHandlerDelegate.FunctionExtractItem funcExtractItem) {
        ItemHandlerDelegate delegate = ItemHandlerDelegate.createFrom(handler);
        delegate.funcExtractItem = funcExtractItem;
        return delegate;
    }

    public static ItemHandlerDelegate createFrom(IItemHandler handler, IItemHandlerDelegate.PredicateIsItemValidForSlot predicate) {
        return ItemHandlerDelegate.createFrom(handler, predicate.toFuncInsertItem());
    }

    public int getSlots() {
        if (this.funcGetSlots == null) {
            return this.delegate.getSlots();
        }
        return this.funcGetSlots.applyAsInt(this.delegate);
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.funcGetStackInSlot == null) {
            return this.delegate.getStackInSlot(slot);
        }
        return this.funcGetStackInSlot.apply(this.delegate, slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.funcInsertItem == null) {
            return this.delegate.insertItem(slot, stack, simulate);
        }
        return this.funcInsertItem.insertItem(this.delegate, slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.funcExtractItem == null) {
            return this.delegate.extractItem(slot, amount, simulate);
        }
        return this.funcExtractItem.extractItem(this.delegate, slot, amount, simulate);
    }
}

