/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.widgets;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.widgets.Widget;
import buildcraft.core.lib.utils.MathUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollbarWidget
extends Widget {
    private static final int HEIGHT = 14;
    private int pos;
    private int len;
    private boolean isClicking;

    public ScrollbarWidget(int x, int y, int u, int v, int h) {
        super(x, y, u, v, 6, h);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
        gui.func_73729_b(guiX + this.x, guiY + this.y, this.u, this.v, this.w, this.h);
        int posPx = this.pos * (this.h - 14 + 2) / this.len;
        gui.func_73729_b(guiX + this.x, guiY + this.y + posPx, this.u + 6, this.v, this.w, 14);
    }

    private void updateLength(int mouseY) {
        this.setPosition(((mouseY - this.y) * this.len + this.h / 2) / this.h);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.isClicking = true;
            this.updateLength(mouseY);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
        if (this.isClicking && mouseButton == 0) {
            this.updateLength(mouseY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleMouseRelease(int mouseX, int mouseY, int eventType) {
        if (this.isClicking && eventType == 0) {
            this.updateLength(mouseY);
            this.isClicking = false;
        }
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = MathUtils.clamp(pos, 0, this.len);
    }

    public void setLength(int len) {
        this.len = len;
        this.setPosition(this.pos);
    }
}

