/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.StatementParameterSlot;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class StatementSlot
extends AdvancedSlot {
    public int slot;
    public ArrayList<StatementParameterSlot> parameters = new ArrayList();

    public StatementSlot(GuiAdvancedInterface gui, int x, int y, int slot) {
        super(gui, x, y);
        this.slot = slot;
    }

    @Override
    public String getDescription() {
        IStatement stmt = this.getStatement();
        if (stmt != null) {
            return stmt.getDescription();
        }
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon() {
        IStatement stmt = this.getStatement();
        if (stmt != null) {
            return stmt.getGuiSprite();
        }
        return null;
    }

    @Override
    public boolean isDefined() {
        return this.getStatement() != null;
    }

    public abstract IStatement getStatement();

    @Override
    public boolean shouldDrawHighlight() {
        return false;
    }
}

