/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.Ledger;
import buildcraft.core.lib.utils.SessionVars;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class LedgerManager {
    protected List<Ledger> ledgers = new ArrayList<Ledger>();
    private final GuiBuildCraft gui;

    public LedgerManager(GuiBuildCraft gui) {
        this.gui = gui;
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public ImmutableList<Ledger> getAll() {
        return ImmutableList.copyOf(this.ledgers);
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    protected Ledger getAtPosition(int mX, int mY) {
        int xShift = (this.gui.field_146294_l - this.gui.xSize()) / 2 + this.gui.xSize();
        int yShift = (this.gui.field_146295_m - this.gui.ySize()) / 2 + 8;
        for (Ledger ledger : this.ledgers) {
            if (!ledger.isVisible()) continue;
            ledger.currentShiftX = xShift;
            ledger.currentShiftY = yShift;
            if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                return ledger;
            }
            yShift += ledger.getHeight();
        }
        return null;
    }

    protected void drawLedgers(int mouseX, int mouseY) {
        int yPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            ledger.draw(this.gui.xSize(), yPos);
            yPos += ledger.getHeight();
        }
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            int startX = mouseX - (this.gui.field_146294_l - this.gui.xSize()) / 2 + 12;
            int startY = mouseY - (this.gui.field_146295_m - this.gui.ySize()) / 2 - 12;
            String tooltip = ledger.getTooltip();
            int textWidth = this.gui.getFontRenderer().func_78256_a(tooltip);
            this.gui.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
            this.gui.getFontRenderer().func_175063_a(tooltip, (float)startX, (float)startY, -1);
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            for (Ledger other : this.ledgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }
}

