/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.core.lib.client.render.RenderUtils;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.SessionVars;
import java.util.Date;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class Ledger {
    private final GuiBuildCraft guiBuildCraft;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected int overlayColor = 0xFFFFFF;
    protected int maxWidth = 124;
    protected int minWidth;
    protected int currentWidth = this.minWidth = 24;
    protected int maxHeight = 24;
    protected int minHeight;
    protected int currentHeight = this.minHeight = 24;
    private boolean open;
    private long lastUpdateTime = -1L;

    public Ledger(GuiBuildCraft guiBuildCraft) {
        this.guiBuildCraft = guiBuildCraft;
    }

    public void update() {
        if (this.lastUpdateTime < 0L) {
            this.lastUpdateTime = new Date().getTime();
        }
        long updateTime = new Date().getTime();
        int updateVal = (int)Math.round((double)(updateTime - this.lastUpdateTime) / 8.0);
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += updateVal;
            this.currentWidth = Math.min(this.maxWidth, this.currentWidth);
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= updateVal;
            this.currentWidth = Math.max(this.minWidth, this.currentWidth);
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += updateVal;
            this.currentHeight = Math.min(this.maxWidth, this.currentHeight);
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= updateVal;
            this.currentHeight = Math.max(this.minHeight, this.currentHeight);
        }
        this.lastUpdateTime = updateTime;
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getWidth() {
        return this.currentWidth;
    }

    public abstract void draw(int var1, int var2);

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionVars.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    protected void drawBackground(int x, int y) {
        RenderUtils.setGLColorFromInt(this.overlayColor);
        this.guiBuildCraft.field_146297_k.field_71446_o.func_110577_a(GuiBuildCraft.LEDGER_TEXTURE);
        this.guiBuildCraft.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
        this.guiBuildCraft.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.guiBuildCraft.func_73729_b(x, y, 0, 0, 4, 4);
        this.guiBuildCraft.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawIcon(TextureAtlasSprite icon, int x, int y) {
        this.guiBuildCraft.func_175175_a(x, y, icon, 16, 16);
    }
}

