/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.fluids;

import buildcraft.core.lib.fluids.Tank;
import com.google.common.collect.ForwardingList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TankManager<T extends Tank>
extends ForwardingList<T>
implements IFluidHandler,
INBTSerializable<NBTTagCompound> {
    private List<T> tanks = new ArrayList<T>();

    public TankManager() {
    }

    public TankManager(T ... tanks) {
        this.addAll(Arrays.asList(tanks));
    }

    protected List<T> delegate() {
        return this.tanks;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        for (Tank tank : this.tanks) {
            int used = tank.fill(resource, doFill);
            if (used <= 0) continue;
            return used;
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        for (Tank tank : this.tanks) {
            FluidStack drained;
            if (!resource.isFluidEqual(tank.getFluid()) || (drained = tank.drain(resource.amount, doDrain)) == null || drained.amount <= 0) continue;
            return drained;
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        for (Tank tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, doDrain);
            if (drained == null || drained.amount <= 0) continue;
            return drained;
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] info = new FluidTankInfo[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            info[i] = ((Tank)((Object)this.get(i))).getInfo();
        }
        return info;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Tank t : this.tanks) {
            nbt.func_74782_a(t.getTankName(), (NBTBase)t.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (Tank t : this.tanks) {
            t.deserializeNBT(nbt.func_74775_l(t.getTankName()));
        }
    }

    @Deprecated
    public void writeToNBT(NBTTagCompound data) {
        for (Tank tank : this.tanks) {
            tank.writeToNBT(data);
        }
    }

    @Deprecated
    public void readFromNBT(NBTTagCompound data) {
        for (Tank tank : this.tanks) {
            tank.readFromNBT(data);
        }
    }

    public void writeData(ByteBuf data) {
        PacketBuffer packet = new PacketBuffer(data);
        for (Tank tank : this.tanks) {
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack != null && fluidStack.getFluid() != null) {
                packet.func_180714_a(fluidStack.getFluid().getName());
                packet.writeInt(fluidStack.amount);
                packet.writeInt(fluidStack.getFluid().getColor(fluidStack));
                continue;
            }
            packet.func_180714_a("~");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readData(ByteBuf data) {
        PacketBuffer packet = new PacketBuffer(data);
        for (Tank tank : this.tanks) {
            String fluidId = packet.func_150789_c(40);
            if (FluidRegistry.getFluid((String)fluidId) != null) {
                tank.setFluid(new FluidStack(FluidRegistry.getFluid((String)fluidId), data.readInt()));
                tank.colorRenderCache = data.readInt();
                continue;
            }
            tank.setFluid(null);
            tank.colorRenderCache = 0xFFFFFF;
        }
    }
}

