/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.fluids;

import buildcraft.core.BCRegistry;
import buildcraft.core.lib.block.BlockBuildCraftFluid;
import buildcraft.core.lib.fluids.BucketHandler;
import buildcraft.core.lib.fluids.ItemBucketBuildcraft;
import buildcraft.core.lib.fluids.MaterialBuildCraftLiquid;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidDefinition {
    public final BCFluid fluid;
    public final BlockBuildCraftFluid block;
    public final MaterialBuildCraftLiquid material;
    public final ItemBucketBuildcraft bucket;

    public FluidDefinition(String fluidName, int density, int viscocity, boolean createBucket) {
        this(fluidName, fluidName, density, viscocity, createBucket, -1, -1);
    }

    public FluidDefinition(String fluidName, String textureSuffix, int density, int viscocity, boolean createBucket, int colourLight, int colourDark) {
        String modid = Loader.instance().activeModContainer().getModId();
        String fluidTextureBase = modid.toLowerCase(Locale.ROOT).replace("|", "") + ":blocks/fluids/" + textureSuffix;
        ResourceLocation still = new ResourceLocation(fluidTextureBase + "_still");
        ResourceLocation flow = new ResourceLocation(fluidTextureBase + "_flow");
        this.fluid = new BCFluid(fluidName, still, flow).setColour(colourLight, colourDark);
        this.fluid.setDensity(density).setViscosity(viscocity);
        if (density < 0) {
            this.fluid.setGaseous(true);
        }
        FluidRegistry.registerFluid((Fluid)this.fluid);
        this.material = new MaterialBuildCraftLiquid(MapColor.field_151646_E);
        this.block = new BlockBuildCraftFluid(this.fluid, (Material)this.material).setFlammability(0);
        this.block.setRegistryName(Loader.instance().activeModContainer().getModId(), "fluid_block_" + fluidName);
        this.block.func_149663_c("blockFluid_" + fluidName);
        BCRegistry.INSTANCE.registerBlock((Block)this.block, true);
        this.fluid.setBlock((Block)this.block);
        FluidStack bucketFluid = new FluidStack((Fluid)this.fluid, 1000);
        this.bucket = new ItemBucketBuildcraft(this.block, this.fluid);
        this.bucket.func_77655_b("bucket_" + fluidName);
        this.bucket.setRegistryName(Loader.instance().activeModContainer().getModId(), "fluid_bucket_" + fluidName);
        BCRegistry.INSTANCE.registerItem((Item)this.bucket, true);
        FluidContainerRegistry.registerFluidContainer((FluidStack)bucketFluid, (ItemStack)new ItemStack((Item)this.bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        BucketHandler.INSTANCE.buckets.put(this.block.func_176223_P().func_177226_a((IProperty)BlockFluidClassic.LEVEL, (Comparable)Integer.valueOf(0)), (Item)this.bucket);
    }

    public final FluidStack createFluidStack(int amount) {
        return new FluidStack((Fluid)this.fluid, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void textureStitchPre(TextureStitchEvent.Pre event) {
        TextureAtlasSprite flow;
        TextureAtlasSprite still = event.map.getTextureExtry(this.fluid.getStill().toString());
        if (still == null) {
            event.map.func_174942_a(this.fluid.getStill());
        }
        if ((flow = event.map.getTextureExtry(this.fluid.getFlowing().toString())) == null) {
            event.map.func_174942_a(this.fluid.getFlowing());
        }
    }

    public static class BCFluid
    extends Fluid {
        private int colour = -1;
        private int light = -1;
        private int dark = -1;
        private int heat;
        private boolean heatable;

        public BCFluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
            super(fluidName, still, flowing);
        }

        public String getLocalizedName(FluidStack stack) {
            if (this.heat <= 0 && !this.isHeatable()) {
                return super.getLocalizedName(stack);
            }
            String name = super.getLocalizedName(stack);
            String heatString = StatCollector.func_74837_a((String)("buildcraft.fluid.heat_" + this.heat), (Object[])new Object[0]);
            return name + heatString;
        }

        public int getColor() {
            return this.colour;
        }

        public int getLightColour() {
            return this.light;
        }

        public int getDarkColour() {
            return this.dark;
        }

        public BCFluid setColour(int colour) {
            this.colour = colour;
            return this;
        }

        public BCFluid setColour(int light, int dark) {
            this.light = light;
            this.dark = dark;
            this.colour = -1;
            return this;
        }

        public BCFluid setHeat(int heat) {
            this.heat = heat;
            return this;
        }

        public int getHeatValue() {
            return this.heat;
        }

        public BCFluid setHeatable(boolean value) {
            this.heatable = value;
            return this;
        }

        public boolean isHeatable() {
            return this.heatable;
        }
    }
}

