/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.config;

import buildcraft.core.lib.config.StreamConfigManager;
import buildcraft.core.proxy.CoreProxy;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class RoamingConfigManager
extends StreamConfigManager {
    private static final Map<ResourceLocation, RoamingConfigManager> instances = new HashMap<ResourceLocation, RoamingConfigManager>();
    private final ResourceLocation location;
    private Boolean cacheExists = null;

    public static RoamingConfigManager getOrCreateDefault(ResourceLocation location) {
        if (!instances.containsKey(location)) {
            instances.put(location, new RoamingConfigManager(location));
        }
        return instances.get(location);
    }

    public RoamingConfigManager(ResourceLocation location) {
        this.location = location;
    }

    @Override
    protected void read() {
        this.cacheExists = null;
        InputStream stream = CoreProxy.proxy.getStreamForResource(this.location);
        if (stream != null) {
            try {
                this.read(stream);
                this.cacheExists = Boolean.TRUE;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        if (this.cacheExists == null) {
            this.cacheExists = Boolean.FALSE;
        }
    }

    public boolean exists() {
        if (this.cacheExists == null) {
            this.read();
        }
        return this.cacheExists;
    }

    @Override
    protected void write() {
    }

    @Override
    protected String comment() {
        return null;
    }
}

