/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.config;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.core.lib.config.Expression;
import buildcraft.core.lib.config.ExpressionCompiler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DetailedConfigOption {
    private static final Set<DetailedConfigOption> allRegistered = new HashSet<DetailedConfigOption>();
    private final String id;
    private final String defaultVal;
    String cache;
    boolean hasWarned;
    private boolean cacheBoolean;
    private long cacheLong;
    private double cacheDouble;
    private Expression cacheExpression;

    public DetailedConfigOption(String name, String defultVal) {
        this.id = name;
        this.defaultVal = defultVal;
        allRegistered.add(this);
    }

    public static void reloadAll() {
        allRegistered.forEach(r -> r.reload());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((DetailedConfigOption)obj).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void reload() {
        this.cache = null;
        this.cacheExpression = null;
    }

    public final String defaultValue() {
        return this.defaultVal;
    }

    protected boolean refresh() {
        return BuildCraftCore.detailedConfigManager.refresh(this, this.id);
    }

    public String getAsString() {
        this.refresh();
        return this.cache;
    }

    public boolean getAsBoolean() {
        if (this.refresh()) {
            this.cacheBoolean = "true".equals(this.cache);
        }
        return this.cacheBoolean;
    }

    public long getAsLong() {
        if (this.refresh()) {
            try {
                this.cacheLong = Long.parseLong(this.cache);
            }
            catch (NumberFormatException nfe) {
                BCLog.logger.warn("Invalid option for " + this.id + ":" + this.cache + ", wanted an integer! " + nfe.getMessage());
                this.cacheLong = 0L;
            }
        }
        return this.cacheLong;
    }

    public double getAsDouble() {
        if (this.refresh()) {
            try {
                this.cacheDouble = Double.parseDouble(this.cache);
            }
            catch (NumberFormatException nfe) {
                BCLog.logger.warn("Invalid option for " + this.id + ":" + this.cache + ", wanted a floating-point! " + nfe.getMessage());
                this.cacheDouble = 0.0;
            }
        }
        return this.cacheDouble;
    }

    public Expression getAsExpression() {
        if (this.refresh()) {
            try {
                String string = this.getAsString();
                this.cacheExpression = ExpressionCompiler.compileExpression(string);
            }
            catch (ExpressionCompiler.InvalidExpressionException iee) {
                BCLog.logger.warn("Invalid expression for " + this.id + ":" + this.cache + ", wanted a valid expression!");
                BCLog.logger.warn("Error: " + iee.getMessage());
                this.cacheLong = 0L;
            }
        }
        return this.cacheExpression;
    }

    public int getAsInt() {
        return (int)this.getAsLong();
    }

    public char getAsChar() {
        return (char)this.getAsLong();
    }

    public byte getAsByte() {
        return (byte)this.getAsLong();
    }

    public float getAsFloat() {
        return (float)this.getAsDouble();
    }

    public float getAsFloatCapped(float min, float max) {
        return Math.min(max, Math.max(min, this.getAsFloat()));
    }

    @SideOnly(value=Side.CLIENT)
    public static enum ReloadListener implements IResourceManagerReloadListener
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
            DetailedConfigOption.reloadAll();
        }
    }
}

