/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.api.core.BCLog;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class MutableVertex {
    private final float[] position = new float[3];
    private final float[] normal = new float[]{-1.0f, -1.0f, -1.0f};
    private final float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final float[] uv = new float[2];
    private final float[] light = new float[2];
    private static Set<String> failedStrings = new HashSet<String>();

    public MutableVertex() {
    }

    public MutableVertex(MutableVertex from) {
        System.arraycopy(from.position, 0, this.position, 0, 3);
        System.arraycopy(from.normal, 0, this.normal, 0, 3);
        System.arraycopy(from.colour, 0, this.colour, 0, 4);
        System.arraycopy(from.uv, 0, this.uv, 0, 2);
        System.arraycopy(from.light, 0, this.light, 0, 2);
    }

    public void setData(float[][] from, VertexFormat vfFrom) {
        int index = 0;
        for (VertexFormatElement elem : vfFrom.func_177343_g()) {
            System.arraycopy(from[index], 0, this.getFor(elem), 0, from[index].length);
            ++index;
        }
    }

    public float[][] getData(VertexFormat as) {
        float[][] data = new float[as.func_177345_h()][];
        int index = 0;
        for (VertexFormatElement elem : as.func_177343_g()) {
            float[] f = this.getFor(elem);
            data[index] = Arrays.copyOf(f, f.length);
            ++index;
        }
        return data;
    }

    private float[] getFor(VertexFormatElement element) {
        String s;
        VertexFormatElement.EnumUsage usage = element.func_177375_c();
        if (usage == VertexFormatElement.EnumUsage.POSITION) {
            return this.position;
        }
        if (usage == VertexFormatElement.EnumUsage.NORMAL) {
            return this.normal;
        }
        if (usage == VertexFormatElement.EnumUsage.COLOR) {
            return this.colour;
        }
        if (usage == VertexFormatElement.EnumUsage.UV) {
            if (element.func_177369_e() == 0) {
                return this.uv;
            }
            if (element.func_177369_e() == 1) {
                return this.light;
            }
        }
        if (!failedStrings.contains(s = element.toString()) && usage != VertexFormatElement.EnumUsage.PADDING) {
            failedStrings.add(s);
            BCLog.logger.info("Element " + s + " failed!");
        }
        return new float[element.func_177370_d()];
    }

    public void render(WorldRenderer wr) {
        VertexFormat vf = wr.func_178973_g();
        for (VertexFormatElement vfe : vf.func_177343_g()) {
            if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                wr.func_181662_b((double)this.position[0], (double)this.position[1], (double)this.position[2]);
                continue;
            }
            if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                wr.func_181663_c(this.normal[0], this.normal[1], this.normal[2]);
                continue;
            }
            if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                wr.func_181666_a(this.colour[0], this.colour[1], this.colour[2], this.colour[3]);
                continue;
            }
            if (vfe.func_177375_c() != VertexFormatElement.EnumUsage.UV) continue;
            if (vfe.func_177369_e() == 0) {
                wr.func_181673_a((double)this.uv[0], (double)this.uv[1]);
                continue;
            }
            if (vfe.func_177369_e() != 1) continue;
            wr.func_181671_a(this.lighti()[0], this.lighti()[1]);
        }
        wr.func_181675_d();
    }

    public MutableVertex positionv(Tuple3f vec) {
        return this.positionf(vec.x, vec.y, vec.z);
    }

    public MutableVertex positionf(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        return this;
    }

    public Point3f position() {
        return new Point3f(this.position);
    }

    public MutableVertex normalv(Vector3f vec) {
        return this.normalf(vec.x, vec.y, vec.z);
    }

    public MutableVertex normalf(float x, float y, float z) {
        this.normal[0] = x;
        this.normal[1] = y;
        this.normal[2] = z;
        return this;
    }

    public MutableVertex invertNormal() {
        return this.normalf(-this.normal[0], -this.normal[1], -this.normal[2]);
    }

    public Vector3f normal() {
        return new Vector3f(this.normal);
    }

    public MutableVertex colourv(Vector4f vec) {
        return this.colourf(vec.x, vec.y, vec.z, vec.w);
    }

    public MutableVertex colourf(float r, float g, float b, float a) {
        this.colour[0] = r;
        this.colour[1] = g;
        this.colour[2] = b;
        this.colour[3] = a;
        return this;
    }

    public MutableVertex colouri(int rgba) {
        return this.colouri(rgba, rgba >> 8, rgba >> 16, rgba >>> 24);
    }

    public MutableVertex colouri(int r, int g, int b, int a) {
        return this.colourf((float)(r & 0xFF) / 255.0f, (float)(g & 0xFF) / 255.0f, (float)(b & 0xFF) / 255.0f, (float)(a & 0xFF) / 255.0f);
    }

    public Vector4f colourv() {
        return new Vector4f(this.colour);
    }

    public int colourRGBA() {
        return (int)(this.colour[0] * 255.0f) + (int)(this.colour[1] * 255.0f) << 8 + (int)(this.colour[2] * 255.0f) << 16 + (int)(this.colour[3] * 255.0f) << 24;
    }

    public MutableVertex texv(Vector2f vec) {
        return this.texf(vec.x, vec.y);
    }

    public MutableVertex texf(float u, float v) {
        this.uv[0] = u;
        this.uv[1] = v;
        return this;
    }

    public Vector2f tex() {
        return new Vector2f(this.uv);
    }

    public MutableVertex lightv(Tuple2f vec) {
        return this.lightf(vec.x, vec.y);
    }

    public MutableVertex lightf(float block, float sky) {
        return this.lighti((int)(block * 15.0f), (int)(sky * 15.0f));
    }

    public MutableVertex lighti(int combined) {
        return this.lighti(combined >> 4, combined >> 20);
    }

    public MutableVertex lighti(int block, int sky) {
        this.light[0] = MutableVertex.light(block);
        this.light[1] = MutableVertex.light(sky);
        return this;
    }

    public Point2f light() {
        return new Point2f(this.light);
    }

    public int lightc() {
        return MutableVertex.light(this.light[0]) << 4 + MutableVertex.light(this.light[1]) << 20;
    }

    public int[] lighti() {
        return new int[]{MutableVertex.light(this.light[0]), MutableVertex.light(this.light[1])};
    }

    private static float light(int val) {
        return (float)(val &= 0xF) * 32.0f / 65535.0f;
    }

    private static int light(float val) {
        return (int)(val * 65535.0f / 32.0f);
    }

    public MutableVertex transform(Matrix4f matrix) {
        Point3f point = this.position();
        matrix.transform(point);
        this.positionv((Tuple3f)point);
        return this;
    }

    public String toString() {
        return "\tVertex [\n\t\tposition=" + Arrays.toString(this.position) + ",\n\t\tnormal=" + Arrays.toString(this.normal) + ",\n\t\tcolour=" + Arrays.toString(this.colour) + ",\n\t\tuv=" + Arrays.toString(this.uv) + ",\n\t\tlight=" + Arrays.toString(this.light) + "\n\t]";
    }
}

