/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.MutableVertex;
import java.util.Arrays;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class MutableQuad {
    public static final VertexFormat ITEM_LMAP = new VertexFormat(DefaultVertexFormats.field_176599_b);
    public static final VertexFormat ITEM_BLOCK_PADDING = new VertexFormat();
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int SHADE = 3;
    public static final int U = 4;
    public static final int V = 5;
    public static final int UNUSED = 6;
    private final MutableVertex[] verticies = new MutableVertex[4];
    private int tintIndex = -1;
    private EnumFacing face = null;

    public static MutableQuad create(BakedQuad quad, VertexFormat format) {
        int[] data = quad.func_178209_a();
        int stride = data.length / 4;
        MutableQuad mutable = new MutableQuad(quad.func_178211_c(), quad.func_178210_d());
        for (int v = 0; v < 4; ++v) {
            MutableVertex mutableVertex = mutable.getVertex(v);
            float x = MutableQuad.fromBits(data[stride * v + 0]);
            float y = MutableQuad.fromBits(data[stride * v + 1]);
            float z = MutableQuad.fromBits(data[stride * v + 2]);
            mutableVertex.positionf(x, y, z);
            mutableVertex.colouri(data[stride * v + 3]);
            float texU = MutableQuad.fromBits(data[stride * v + 4]);
            float texV = MutableQuad.fromBits(data[stride * v + 5]);
            mutableVertex.texf(texU, texV);
            if (format == DefaultVertexFormats.field_176600_a) {
                int lightmap = data[stride * v + 6];
                mutableVertex.lighti(lightmap);
                continue;
            }
            if (format != DefaultVertexFormats.field_176599_b) continue;
            int n = data[stride * v + 6];
        }
        return mutable;
    }

    public static MutableQuad create(BakedQuad quad) {
        return MutableQuad.create(quad, ITEM_BLOCK_PADDING);
    }

    public static float fromBits(int bits) {
        return Float.intBitsToFloat(bits);
    }

    public MutableQuad(int tintIndex, EnumFacing face) {
        this.tintIndex = tintIndex;
        this.face = face;
        for (int v = 0; v < 4; ++v) {
            this.verticies[v] = new MutableVertex();
        }
    }

    public MutableQuad(VertexFormat format, float[][][] data, int tintIndex, EnumFacing face) {
        this(tintIndex, face);
        for (int v = 0; v < 4; ++v) {
            this.verticies[v].setData(data[v], format);
        }
    }

    public MutableQuad(MutableQuad from) {
        this.tintIndex = from.tintIndex;
        this.face = from.face;
        for (int i = 0; i < 4; ++i) {
            this.verticies[i] = new MutableVertex(from.verticies[i]);
        }
    }

    public MutableQuad setTint(int tint) {
        this.tintIndex = tint;
        return this;
    }

    public int getTint() {
        return this.tintIndex;
    }

    public MutableQuad setFace(EnumFacing face) {
        this.face = face;
        return this;
    }

    public EnumFacing getFace() {
        return this.face;
    }

    public UnpackedBakedQuad toUnpacked() {
        return this.toUnpacked(ITEM_LMAP);
    }

    public UnpackedBakedQuad toUnpacked(VertexFormat format) {
        float[][][] data = new float[4][][];
        for (int vertex = 0; vertex < 4; ++vertex) {
            float[][] fromData = this.verticies[vertex].getData(format);
            data[vertex] = new float[fromData.length][];
            for (int element = 0; element < fromData.length; ++element) {
                data[vertex][element] = new float[fromData[element].length];
                for (int d = 0; d < fromData[element].length; ++d) {
                    data[vertex][element][d] = fromData[element][d];
                }
            }
        }
        return new UnpackedBakedQuad((float[][][])data, this.tintIndex, this.face, format);
    }

    public void render(WorldRenderer wr) {
        for (MutableVertex v : this.verticies) {
            v.render(wr);
        }
    }

    public MutableVertex getVertex(int v) {
        return this.verticies[v & 3];
    }

    public Vector3f getCalculatedNormal() {
        Point3f[] positions = new Point3f[]{this.getVertex(0).position(), this.getVertex(1).position(), this.getVertex(2).position()};
        Vector3f a = new Vector3f((Tuple3f)positions[1]);
        a.sub((Tuple3f)positions[0]);
        Vector3f b = new Vector3f((Tuple3f)positions[2]);
        b.sub((Tuple3f)positions[0]);
        Vector3f c = new Vector3f();
        c.cross(a, b);
        return c;
    }

    public void setCalculatedNormal() {
        this.normalv(this.getCalculatedNormal());
    }

    public static float diffuseLight(Vector3f normal) {
        return MutableQuad.diffuseLight(normal.x, normal.y, normal.z);
    }

    public static float diffuseLight(float x, float y, float z) {
        boolean up = y >= 0.0f;
        float xx = x * x;
        float yy = y * y;
        float zz = z * z;
        float t = xx + yy + zz;
        float light = (xx * 0.6f + zz * 0.8f) / t;
        float yyt = yy / t;
        if (!up) {
            yyt = (float)((double)yyt * 0.5);
        }
        return light += yyt;
    }

    public float getCalculatedDiffuse() {
        return MutableQuad.diffuseLight(this.getCalculatedNormal());
    }

    public void setCalculatedDiffuse() {
        float diffuse = this.getCalculatedDiffuse();
        this.colourf(diffuse, diffuse, diffuse, 1.0f);
    }

    public MutableQuad invertNormal() {
        MutableVertex[] newArray = new MutableVertex[]{this.verticies[3], this.verticies[2], this.verticies[1], this.verticies[0]};
        for (int i = 0; i < 4; ++i) {
            this.verticies[i] = newArray[i].invertNormal();
        }
        return this;
    }

    public MutableQuad normalv(Vector3f vec) {
        Arrays.stream(this.verticies).forEach(v -> v.normalv(vec));
        return this;
    }

    public MutableQuad normalf(float x, float y, float z) {
        Arrays.stream(this.verticies).forEach(v -> v.normalf(x, y, z));
        return this;
    }

    public MutableQuad colourv(Vector4f vec) {
        Arrays.stream(this.verticies).forEach(v -> v.colourv(vec));
        return this;
    }

    public MutableQuad colourf(float r, float g, float b, float a) {
        Arrays.stream(this.verticies).forEach(v -> v.colourf(r, g, b, a));
        return this;
    }

    public MutableQuad colouri(int rgba) {
        Arrays.stream(this.verticies).forEach(v -> v.colouri(rgba));
        return this;
    }

    public MutableQuad colouri(int r, int g, int b, int a) {
        Arrays.stream(this.verticies).forEach(v -> v.colouri(r, g, b, a));
        return this;
    }

    public MutableQuad lightv(Vector2f vec) {
        for (MutableVertex v : this.verticies) {
            v.lightv((Tuple2f)vec);
        }
        return this;
    }

    public MutableQuad lightf(float block, float sky) {
        for (MutableVertex v : this.verticies) {
            v.lightf(block, sky);
        }
        return this;
    }

    public MutableQuad lighti(int combined) {
        for (MutableVertex v : this.verticies) {
            v.lighti(combined);
        }
        return this;
    }

    public MutableQuad lighti(int block, int sky) {
        for (MutableVertex v : this.verticies) {
            v.lighti(block, sky);
        }
        return this;
    }

    public MutableQuad transform(Matrix4f transformation) {
        for (MutableVertex v : this.verticies) {
            v.transform(transformation);
        }
        return this;
    }

    public String toString() {
        return "MutableQuad [verticies=" + this.vToS() + ", tintIndex=" + this.tintIndex + ", face=" + this.face + "]";
    }

    private String vToS() {
        StringBuilder builder = new StringBuilder();
        for (MutableVertex v : this.verticies) {
            builder.append(v.toString() + "\n");
        }
        return builder.toString();
    }

    static {
        ITEM_LMAP.func_181721_a(DefaultVertexFormats.field_181716_p);
        ITEM_BLOCK_PADDING.func_181721_a(DefaultVertexFormats.field_181713_m);
        ITEM_BLOCK_PADDING.func_181721_a(DefaultVertexFormats.field_181714_n);
        ITEM_BLOCK_PADDING.func_181721_a(DefaultVertexFormats.field_181715_o);
        ITEM_BLOCK_PADDING.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.INT, VertexFormatElement.EnumUsage.PADDING, 1));
    }
}

