/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.ModelCache;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class ModelCacheBuilder<K> {
    final String detailedName;
    final ModelCache.IModelGenerator<K> generator;
    int maxSize = 1600;
    boolean keepMutable = true;
    boolean needGL = false;
    VertexFormat glVertexFormat;

    public ModelCacheBuilder(String detailedName, ModelCache.IModelGenerator<K> generator) {
        this.detailedName = detailedName;
        this.generator = generator;
    }

    public ModelCacheBuilder<K> setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public ModelCacheBuilder<K> setKeepMutable(boolean keep) {
        this.keepMutable = keep;
        return this;
    }

    public ModelCacheBuilder<K> enableGL(VertexFormat glVertexFormat) {
        this.needGL = true;
        this.glVertexFormat = glVertexFormat;
        return this;
    }

    public ModelCacheBuilder<K> disableGL() {
        this.needGL = false;
        this.glVertexFormat = null;
        return this;
    }

    public ModelCache<K> build() {
        return new ModelCache(this);
    }
}

