/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCacheBuilder;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.config.DetailedConfigOption;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.lwjgl.opengl.GL11;

public class ModelCache<K>
implements IModelCache<K> {
    private static final DetailedConfigOption OPTION_DEBUG = new DetailedConfigOption("render.cache.debug", "false");
    private final String name;
    private final DetailedConfigOption optionCacheSize;
    private final IModelGenerator<K> generator;
    private final LoadingCache<K, ModelValue> modelCache;
    private final boolean keepMutable;
    private final boolean needGL;
    private final VertexFormat glVertexFormat;

    public ModelCache(String detailedName, IModelGenerator<K> generator) {
        this(detailedName, 1600, generator);
    }

    public ModelCache(String detailedName, int defaultMaxSize, IModelGenerator<K> generator) {
        this(new ModelCacheBuilder<K>(detailedName, generator).setMaxSize(defaultMaxSize));
    }

    public ModelCache(ModelCacheBuilder<K> builder) {
        this.generator = builder.generator;
        this.name = builder.detailedName;
        int defaultMaxSize = builder.maxSize;
        this.optionCacheSize = new DetailedConfigOption("render.cache." + this.name + ".maxsize", Integer.toString(defaultMaxSize));
        int maxSize = this.optionCacheSize.getAsInt();
        if (maxSize < 0) {
            maxSize = 0;
        }
        if (OPTION_DEBUG.getAsBoolean()) {
            BCLog.logger.info("Making cache " + this.name + " with a maximum size of " + maxSize);
        }
        this.modelCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).removalListener(this::onRemove).build(CacheLoader.from(this::load));
        this.keepMutable = builder.keepMutable;
        this.needGL = builder.needGL;
        this.glVertexFormat = builder.glVertexFormat;
    }

    private void onRemove(RemovalNotification<K, ModelValue> notification) {
        if (OPTION_DEBUG.getAsBoolean()) {
            BCLog.logger.info("Cache[" + this.name + "]Remove: " + notification.getKey());
        }
        ((ModelValue)notification.getValue()).cleanup();
    }

    private ModelValue load(K key) {
        if (OPTION_DEBUG.getAsBoolean()) {
            BCLog.logger.info("Cache[" + this.name + "]Miss: " + key);
        }
        return new ModelValue(this.generator.generate(key));
    }

    @Override
    public void appendAsMutable(K key, List<MutableQuad> quads) {
        quads.addAll((Collection<MutableQuad>)((ModelValue)this.modelCache.getUnchecked(key)).mutableQuads);
    }

    @Override
    public ImmutableList<BakedQuad> bake(K key, VertexFormat format) {
        ModelValue value = (ModelValue)this.modelCache.getUnchecked(key);
        return value.bake(format);
    }

    @Override
    public void render(K key, WorldRenderer wr) {
        for (MutableQuad q : ((ModelValue)this.modelCache.getUnchecked(key)).mutableQuads) {
            q.render(wr);
        }
    }

    @Override
    public void renderDisplayList(K key) {
        ModelValue value = (ModelValue)this.modelCache.getUnchecked(key);
        GL11.glCallList((int)value.glDisplayList);
    }

    private class ModelValue {
        private final ImmutableList<MutableQuad> mutableQuads;
        private Map<VertexFormat, ImmutableList<BakedQuad>> bakedQuads = new IdentityHashMap<VertexFormat, ImmutableList<BakedQuad>>();
        private int glDisplayList;

        public ModelValue(List<MutableQuad> quads) {
            this.mutableQuads = ModelCache.this.keepMutable ? ImmutableList.copyOf(quads) : ImmutableList.of();
            if (ModelCache.this.needGL) {
                this.glDisplayList = GLAllocation.func_74526_a((int)1);
                GL11.glNewList((int)this.glDisplayList, (int)4864);
                Tessellator t = Tessellator.func_178181_a();
                WorldRenderer wr = t.func_178180_c();
                wr.func_181668_a(7, ModelCache.this.glVertexFormat);
                for (MutableQuad q : quads) {
                    q.render(wr);
                }
                t.func_78381_a();
                GL11.glEndList();
            } else {
                this.glDisplayList = -1;
            }
        }

        public ImmutableList<BakedQuad> bake(VertexFormat format) {
            if (!this.bakedQuads.containsKey(format)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (MutableQuad mutable : this.mutableQuads) {
                    builder.add((Object)mutable.toUnpacked(format));
                }
                this.bakedQuads.put(format, (ImmutableList<BakedQuad>)builder.build());
            }
            return this.bakedQuads.get(format);
        }

        private void cleanup() {
            if (this.glDisplayList > 0) {
                GLAllocation.func_74523_b((int)this.glDisplayList);
                this.glDisplayList = -1;
            }
        }
    }

    public static interface IModelGenerator<T> {
        public List<MutableQuad> generate(T var1);
    }
}

