/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;

public class ModelBCFluid
implements IModel {
    private final Fluid fluid;

    public ModelBCFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new BakedFluid((Optional<TRSRTransformation>)state.apply(Optional.absent()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, this.fluid.getColor(), (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.fluid.getStill()), (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.fluid.getFlowing()), this.fluid.isGaseous(), (Optional<IExtendedBlockState>)Optional.absent());
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public static class BakedFluid
    implements ISmartBlockModel,
    IPerspectiveAwareModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) throws Exception {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                return new BakedFluid((Optional<TRSRTransformation>)transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, format, color, still, flowing, gas, statePresent, cornerRound, flowRound);
            }
        });
        private final Optional<TRSRTransformation> transformation;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final int color;
        private final TextureAtlasSprite still;
        private final TextureAtlasSprite flowing;
        private final boolean gas;
        private final EnumMap<EnumFacing, List<BakedQuad>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas) {
            this(transformation, format, color, still, flowing, gas, (Optional<IExtendedBlockState>)Optional.absent());
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.of(), format, color, still, flowing, gas, stateOption);
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, transforms, format, color, still, flowing, gas, stateOption.isPresent(), BakedFluid.getCorners(stateOption), BakedFluid.getFlow(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = (IExtendedBlockState)stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = Math.round(((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[i])).floatValue() * 768.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            float flow = -1000.0f;
            if (stateOption.isPresent()) {
                flow = ((Float)((IExtendedBlockState)stateOption.get()).getValue((IUnlistedProperty)BlockFluidBase.FLOW_DIRECTION)).floatValue();
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow));
            flowRound = MathHelper.func_76125_a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int color, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas, boolean statePresent, int[] cornerRound, int flowRound) {
            int i;
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.gas = gas;
            this.faceQuads = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing side : EnumFacing.values()) {
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of());
            }
            if (statePresent) {
                int i2;
                float[] y = new float[4];
                for (i = 0; i < 4; ++i) {
                    y[i] = gas ? 1.0f - (float)cornerRound[i] / 768.0f : (float)cornerRound[i] / 768.0f;
                }
                float flow = (float)Math.toRadians(flowRound);
                TextureAtlasSprite topSprite = flowing;
                float scale = 4.0f;
                if (flow < -17.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c = MathHelper.func_76134_b((float)flow) * scale;
                float s = MathHelper.func_76126_a((float)flow) * scale;
                EnumFacing side = gas ? EnumFacing.DOWN : EnumFacing.UP;
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                UnpackedBakedQuad.Builder builder2 = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder2.setQuadOrientation(side);
                builder.setQuadColored();
                builder2.setQuadColored();
                int[] inverseSpriteArray = new int[]{0, 3, 2, 1};
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    int a = inverseSpriteArray[i2];
                    this.putVertex(builder2, side, x[a], y[a], z[a], topSprite.func_94214_a((double)(8.0f + c * (float)(x[a] * 2 - 1) + s * (float)(z[a] * 2 - 1))), topSprite.func_94207_b((double)(8.0f + c * (float)(x[(a + 1) % 4] * 2 - 1) + s * (float)(z[(a + 1) % 4] * 2 - 1))));
                }
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of((Object)builder2.build()));
                side = side.func_176734_d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setQuadColored();
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    this.putVertex(builder, side, z[i2], gas ? 1.0f : 0.0f, x[i2], still.func_94214_a((double)(z[i2] * 16)), still.func_94207_b((double)(x[i2] * 16)));
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    side = EnumFacing.func_176731_b((int)((5 - i2) % 4));
                    BakedQuad[] q = new BakedQuad[2];
                    for (int k = 0; k < 2; ++k) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setQuadColored();
                        for (int j = 0; j < 4; ++j) {
                            int l = k * 3 + (1 - 2 * k) * j;
                            float yl = (float)z[l] * y[(i2 + x[l]) % 4];
                            if (gas && z[l] == 0) {
                                yl = 1.0f;
                            }
                            this.putVertex(builder, side, x[(i2 + x[l]) % 4], yl, z[(i2 + x[l]) % 4], flowing.func_94214_a((double)(x[l] * 8)), flowing.func_94207_b((double)((gas ? yl : 1.0f - yl) * 8.0f)));
                        }
                        q[k] = builder.build();
                    }
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(EnumFacing.UP);
                builder.setQuadColored();
                for (i = 0; i < 4; ++i) {
                    this.putVertex(builder, EnumFacing.UP, z[i], x[i], 0.0f, still.func_94214_a((double)(z[i] * 16)), still.func_94207_b((double)(x[i] * 16)));
                }
                this.faceQuads.put(EnumFacing.SOUTH, (List<BakedQuad>)ImmutableList.of((Object)builder.build()));
            }
        }

        private void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, float x, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        float[] data = new float[]{x - (float)side.func_176730_m().func_177958_n() * 0.001f, y, z - (float)side.func_176730_m().func_177952_p() * 0.001f, 1.0f};
                        if (this.transformation.isPresent() && this.transformation.get() != TRSRTransformation.identity()) {
                            Vector4f vec = new Vector4f(data);
                            ((TRSRTransformation)this.transformation.get()).getMatrix().transform((Tuple4f)vec);
                            vec.get(data);
                        }
                        builder.put(e, data);
                        continue block6;
                    }
                    case COLOR: {
                        float d = LightUtil.diffuseLight((EnumFacing)side);
                        builder.put(e, new float[]{d * (float)(this.color >> 16 & 0xFF) / 255.0f, d * (float)(this.color >> 8 & 0xFF) / 255.0f, d * (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f});
                        continue block6;
                    }
                    case UV: {
                        if (this.format.func_177348_c(e).func_177369_e() == 0) {
                            builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                            continue block6;
                        }
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.still;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public List<BakedQuad> func_177551_a(EnumFacing side) {
            return this.faceQuads.get(side);
        }

        public List<BakedQuad> func_177550_a() {
            return ImmutableList.of();
        }

        public VertexFormat getFormat() {
            return this.format;
        }

        public IBakedModel handleBlockState(IBlockState state) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                int[] cornerRound = BakedFluid.getCorners((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                int flowRound = BakedFluid.getFlow((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                long key = flowRound + 1024;
                for (int i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                return (IBakedModel)this.modelCache.getUnchecked((Object)(key |= 1L));
            }
            return this;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

