/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.util.EnumFacing;

public enum FacingRotationHelper {
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST);

    private static final EnumMap<EnumFacing, FacingRotationHelper> helperForFaceMap;
    public final EnumFacing face;
    private final EnumMap<EnumFacing, EnumMap<EnumFacing, EnumFacing>> facingMap;

    public static FacingRotationHelper helperForFace(EnumFacing face) {
        return helperForFaceMap.get(face);
    }

    public static EnumFacing rotateFace(EnumFacing model, EnumFacing to, EnumFacing face) {
        return FacingRotationHelper.helperForFace(model).rotateFace(to, face);
    }

    private FacingRotationHelper(EnumFacing face) {
        this.face = face;
        this.facingMap = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing key : EnumFacing.values()) {
            int numRotations;
            EnumMap map = Maps.newEnumMap(EnumFacing.class);
            this.facingMap.put(key, map);
            EnumFacing.Axis faceAxis = face.func_176740_k();
            EnumFacing.Axis keyAxis = key.func_176740_k();
            EnumFacing.Axis rotationAxis = Utils.other(faceAxis, keyAxis);
            if (face == key) {
                numRotations = 0;
            } else if (face.func_176734_d() == key) {
                numRotations = 2;
            } else {
                EnumFacing rotated = key.func_176732_a(rotationAxis);
                if (rotated == face) {
                    numRotations = 1;
                } else if (rotated == face.func_176734_d()) {
                    numRotations = 3;
                } else {
                    throw new IllegalStateException("Dammit AlexIIL! You made a mistake (face = " + face + ", key = " + key + ", rotationAxis = " + rotationAxis + ", rotated = " + rotated + ")");
                }
            }
            EnumFacing[] enumFacingArray = EnumFacing.values();
            int n2 = enumFacingArray.length;
            for (int i = 0; i < n2; ++i) {
                EnumFacing val;
                EnumFacing rotated = val = enumFacingArray[i];
                if (val.func_176740_k() != rotationAxis) {
                    for (int i2 = 0; i2 < numRotations; ++i2) {
                        rotated = rotated.func_176732_a(rotationAxis);
                    }
                }
                map.put(val, rotated);
            }
        }
    }

    public EnumFacing rotateFace(EnumFacing to, EnumFacing face) {
        return this.facingMap.get(to).get(face);
    }

    static {
        helperForFaceMap = Maps.newEnumMap(EnumFacing.class);
        for (FacingRotationHelper helper : FacingRotationHelper.values()) {
            helperForFaceMap.put(helper.face, helper);
        }
    }
}

