/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.client.model.PerspAwareModelBase;
import buildcraft.core.lib.utils.MatrixUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;

public class BuildCraftBakedModel
extends PerspAwareModelBase {
    public static final int U_MIN = 0;
    public static final int U_MAX = 1;
    public static final int V_MIN = 2;
    public static final int V_MAX = 3;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int SHADE = 3;
    public static final int U = 4;
    public static final int V = 5;
    public static final int UNUSED = 6;
    public static final int ARRAY_SIZE = 7;

    public BuildCraftBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super(format, quads, particle, transforms);
    }

    public BuildCraftBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        this(quads, particle, format, BuildCraftBakedModel.getBlockTransforms());
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBlockTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null)));
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.setIdentity();
        rotationMatrix = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.EAST);
        Matrix4f result = new Matrix4f();
        result.setIdentity();
        result.mul(rotationMatrix);
        TRSRTransformation trsr = new TRSRTransformation(result);
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)trsr);
        return builder.build();
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getItemTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        float scale = 0.375f;
        Vector3f translation = new Vector3f(0.0f, 1.5f * scale, -2.75f * scale);
        TRSRTransformation trsr = new TRSRTransformation(translation, new Quat4f(10.0f, -45.0f, 170.0f, 1.0f), new Vector3f(0.375f, 0.375f, 0.375f), null);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)trsr);
        translation = new Vector3f(1.0f, 1.0f, 0.0f);
        trsr = new TRSRTransformation(translation, new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, -90.0f, 90.0f, 1.0f));
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)trsr);
        return builder.build();
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getPluggableTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Quat4f rotation = TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f));
        TRSRTransformation trsr = new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), rotation, new Vector3f(0.375f, 0.375f, 0.375f), null);
        trsr = TRSRTransformation.blockCenterToCorner((TRSRTransformation)trsr);
        Matrix4f trsrMatrix = trsr.getMatrix();
        Matrix4f result = new Matrix4f();
        result.setIdentity();
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.setIdentity();
        rotationMatrix = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.NORTH);
        result.mul(trsrMatrix);
        result.mul(rotationMatrix);
        trsr = new TRSRTransformation(result);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)trsr);
        Matrix4f rotationMatrix2 = new Matrix4f();
        rotationMatrix2.setIdentity();
        rotationMatrix2 = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.EAST);
        Matrix4f result2 = new Matrix4f();
        result2.setIdentity();
        result2.mul(rotationMatrix2);
        TRSRTransformation trsr2 = new TRSRTransformation(result2);
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON, (Object)trsr2);
        return builder.build();
    }

    public static String toStringPretty(BakedQuad unpacked) {
        StringBuilder builder = new StringBuilder();
        int[] data = unpacked.func_178209_a();
        int stride = data.length / 4;
        for (int v = 0; v < 4; ++v) {
            builder.append("\nV#" + v + "=[");
            for (int e = 0; e < stride; ++e) {
                if (e != 0) {
                    builder.append(", ");
                }
                int d = data[v * stride + e];
                builder.append(Integer.toHexString(d));
            }
            builder.append("]");
        }
        String s = builder.toString();
        return s;
    }

    public static IBakedModel createModelItemLayer(TextureAtlasSprite sprite) {
        return BuildCraftBakedModel.createModelItemLayer(Lists.newArrayList((Object[])new TextureAtlasSprite[]{sprite}));
    }

    public static IBakedModel createModelItemLayer(List<TextureAtlasSprite> sprites) {
        List<BakedQuad> quads = BCModelHelper.bakeList(BuildCraftBakedModel.createQuadsItemLayer(sprites));
        return new BuildCraftBakedModel((ImmutableList<BakedQuad>)ImmutableList.copyOf(quads), sprites.get(0), MutableQuad.ITEM_LMAP);
    }

    public static List<MutableQuad> createQuadsItemLayer(TextureAtlasSprite sprite) {
        return BuildCraftBakedModel.createQuadsItemLayer(Lists.newArrayList((Object[])new TextureAtlasSprite[]{sprite}));
    }

    public static List<MutableQuad> createQuadsItemLayer(final List<TextureAtlasSprite> sprites) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < sprites.size(); ++i) {
            builder.add((Object)new ResourceLocation("buildcraftbakedmodel:spriteindex" + i));
        }
        final ImmutableList locations = builder.build();
        ItemLayerModel model = new ItemLayerModel(locations);
        IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return (TextureAtlasSprite)sprites.get(locations.indexOf((Object)input));
            }
        });
        Matrix4f itemToEdge = new Matrix4f();
        itemToEdge.setIdentity();
        itemToEdge.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.5707964f));
        Matrix4f translation = new Matrix4f();
        translation.setIdentity();
        translation.setTranslation(new Vector3f(-0.46875f, 0.0f, 1.0f));
        translation.mul(itemToEdge);
        List<MutableQuad> mutableQuads = BCModelHelper.toMutableQuadList((IBakedModel)baked, false);
        for (MutableQuad mutable : mutableQuads) {
            mutable.transform(translation);
            mutable.setTint(-1);
        }
        return mutableQuads;
    }

    public static Function<ResourceLocation, TextureAtlasSprite> singleTextureFunction(final TextureAtlasSprite sprite) {
        if (sprite == null) {
            throw new NullPointerException("sprite");
        }
        return new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return sprite;
            }
        };
    }
}

