/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.ISerializable;
import buildcraft.api.properties.BuildCraftProperty;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.block.IAdditionalDataTile;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.StringUtils;

public abstract class TileBuildCraft
extends TileEntity
implements IEnergyProvider,
IEnergyReceiver,
ISerializable,
ITickable,
IAdditionalDataTile {
    protected TileBuffer[] cache;
    protected HashSet<EntityPlayer> guiWatchers = new HashSet();
    protected IControllable.Mode mode;
    private boolean sendNetworkUpdate = false;
    protected int init = 0;
    private String owner = "[BuildCraft]";
    private RFBattery battery;
    private int receivedTick;
    private int extractedTick;
    private long worldTimeEnergyReceive;
    public int ledPower = 0;
    public int lastLedPower = 0;
    public boolean ledDone = false;
    public boolean lastLedDone = false;
    private NBTTagCompound lastBlockState = null;
    private IItemHandler[] invWrapper;

    public String getOwner() {
        return this.owner;
    }

    public void addGuiWatcher(EntityPlayer player) {
        if (!this.guiWatchers.contains(player)) {
            this.guiWatchers.add(player);
        }
    }

    public void removeGuiWatcher(EntityPlayer player) {
        if (this.guiWatchers.contains(player)) {
            this.guiWatchers.remove(player);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            throw new NullPointerException("worldObj");
        }
        if (this.init != 2 && !this.func_145837_r()) {
            if (this.init < 1) {
                ++this.init;
                return;
            }
            this.initialize();
            this.init = 2;
        }
        if (this.battery != null) {
            this.receivedTick = 0;
            this.extractedTick = 0;
            if (!this.field_145850_b.field_72995_K) {
                int prePower = this.ledPower;
                int stored = this.battery.getEnergyStored();
                int max = this.battery.getMaxEnergyStored();
                this.ledPower = 0;
                if (stored != 0) {
                    this.ledPower = stored * 2 / max + 1;
                }
                if (prePower != this.ledPower) {
                    this.sendNetworkUpdate();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.battery != null) {
            this.ledPower = this.battery.getMaxEnergyStored() > 0 ? 3 * this.battery.getEnergyStored() / this.battery.getMaxEnergyStored() : 0;
        }
        if (this.lastLedPower != this.ledPower || this.lastLedDone != this.ledDone) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175689_h(this.func_174877_v());
            } else {
                this.sendNetworkUpdate();
            }
            this.lastLedPower = this.ledPower;
            this.lastLedDone = this.ledDone;
        }
        if (this.sendNetworkUpdate && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToPlayers(this.getPacketUpdate(), this.field_145850_b, this.func_174877_v(), DefaultProps.NETWORK_UPDATE_RANGE);
            this.sendNetworkUpdate = false;
        }
    }

    public void initialize() {
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.cache = null;
    }

    public void func_145843_s() {
        this.init = 0;
        super.func_145843_s();
        this.cache = null;
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).getDisplayNameString();
        }
    }

    public void destroy() {
        this.cache = null;
    }

    @Override
    public void sendNetworkUpdate() {
        this.sendNetworkUpdate = true;
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeByte(this.ledPower);
        NetworkUtils.writeEnum(stream, this.mode);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.ledPower = stream.readByte();
        this.mode = NetworkUtils.readEnum(stream, IControllable.Mode.class);
    }

    public PacketTileUpdate getPacketUpdate() {
        return new PacketTileUpdate(this, this);
    }

    public S35PacketUpdateTileEntity getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("net-type", "desc-packet");
        PacketTileUpdate p = this.getPacketUpdate();
        ByteBuf buf = Unpooled.buffer();
        ((Packet)p).writeData(buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        nbt.func_74773_a("net-data", bytes);
        S35PacketUpdateTileEntity tileUpdate = new S35PacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
        return tileUpdate;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (pkt.func_148857_g() == null) {
            throw new RuntimeException("No NBTTag compound! This is a bug!");
        }
        NBTTagCompound nbt = pkt.func_148857_g();
        try {
            if ("desc-packet".equals(nbt.func_74779_i("net-type"))) {
                byte[] bytes = nbt.func_74770_j("net-data");
                ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
                PacketTileUpdate p = new PacketTileUpdate();
                p.readData(data);
                p.applyData(this.field_145850_b, null);
            } else {
                BCLog.logger.warn("Recieved a packet with a different type that expected (" + nbt.func_74779_i("net-type") + ")");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to read a packet! (net-type=\"" + nbt.func_74781_a("net-type") + "\", net-data=\"" + nbt.func_74781_a("net-data") + "\")", t);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        IBlockState blockstate;
        Block block;
        super.func_145841_b(nbt);
        nbt.func_74778_a("owner", this.owner);
        if (this.battery != null) {
            NBTTagCompound batteryNBT = new NBTTagCompound();
            this.battery.writeToNBT(batteryNBT);
            nbt.func_74782_a("battery", (NBTBase)batteryNBT);
        }
        if (this.mode != null) {
            nbt.func_74774_a("lastMode", (byte)this.mode.ordinal());
        }
        nbt.func_74768_a("data-version", 1);
        if (this.func_145830_o() && (block = (blockstate = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c()) instanceof BlockBuildCraft) {
            BlockBuildCraft bcBlock = (BlockBuildCraft)block;
            NBTTagCompound statenbt = new NBTTagCompound();
            for (BuildCraftProperty prop : bcBlock.properties) {
                Comparable value = blockstate.func_177229_b((IProperty)prop);
                if (value == null) continue;
                statenbt.func_74782_a(prop.func_177701_a(), NBTUtils.writeObject(value));
            }
            nbt.func_74782_a("blockstate", (NBTBase)statenbt);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
        if (this.battery != null) {
            this.battery.readFromNBT(nbt.func_74775_l("battery"));
        }
        if (nbt.func_74764_b("lastMode")) {
            this.mode = IControllable.Mode.values()[nbt.func_74771_c("lastMode")];
        }
        int version = nbt.func_74762_e("data-version");
        if (nbt.func_74764_b("blockstate") && version == 1) {
            this.lastBlockState = nbt.func_74775_l("blockstate");
        }
    }

    protected int getTicksSinceEnergyReceived() {
        return (int)(this.field_145850_b.func_82737_E() - this.worldTimeEnergyReceive);
    }

    public int hashCode() {
        return this.field_174879_c.hashCode();
    }

    public boolean equals(Object cmp) {
        return this == cmp;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.battery != null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int received = this.battery.receiveEnergy(Math.min(maxReceive, this.battery.getMaxEnergyReceive() - this.receivedTick), simulate);
            if (!simulate) {
                this.receivedTick += received;
                this.worldTimeEnergyReceive = this.field_145850_b.func_82737_E();
            }
            return received;
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int extracted = this.battery.extractEnergy(Math.min(maxExtract, this.battery.getMaxEnergyExtract() - this.extractedTick), simulate);
            if (!simulate) {
                this.extractedTick += extracted;
            }
            return extracted;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getMaxEnergyStored();
        }
        return 0;
    }

    public RFBattery getBattery() {
        return this.battery;
    }

    protected void setBattery(RFBattery battery) {
        this.battery = battery;
    }

    public IBlockState getBlockState(EnumFacing side) {
        if (this.isNotReady()) {
            return null;
        }
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, false);
        }
        return this.cache[side.ordinal()].getBlockState();
    }

    public TileEntity getTile(EnumFacing side) {
        if (this.isNotReady()) {
            return null;
        }
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, false);
        }
        return this.cache[side.ordinal()].getTile();
    }

    public IControllable.Mode getControlMode() {
        return this.mode;
    }

    public void setControlMode(IControllable.Mode mode) {
        this.mode = mode;
        this.sendNetworkUpdate();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this instanceof IInventory;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof IInventory) {
                if (this.invWrapper == null) {
                    if (this instanceof ISidedInventory) {
                        this.invWrapper = new IItemHandler[7];
                        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                            this.invWrapper[facing1.ordinal()] = new SidedInvWrapper((ISidedInventory)this, facing);
                        }
                        this.invWrapper[6] = new SidedInvWrapper((ISidedInventory)this, null);
                    } else {
                        this.invWrapper = new IItemHandler[1];
                        this.invWrapper[0] = new InvWrapper((IInventory)this);
                    }
                }
                if (this.invWrapper.length == 7) {
                    return (T)this.invWrapper[facing == null ? 6 : facing.ordinal()];
                }
                return (T)this.invWrapper[0];
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public String getInventoryName() {
        return "";
    }

    public String getName() {
        return this.getInventoryName();
    }

    public IChatComponent getDisplayName() {
        return new ChatComponentText(this.getInventoryName());
    }

    public void clear() {
    }

    public boolean hasCustomName() {
        return !StringUtils.isEmpty((CharSequence)this.getInventoryName());
    }

    public boolean isNotReady() {
        return !this.func_145830_o() || this.init != 2;
    }
}

