/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.core.lib.client.render.EntityDropParticleFX;
import buildcraft.core.lib.utils.ICustomStateMapper;
import buildcraft.core.lib.utils.ModelHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBuildCraftFluid
extends BlockFluidClassic
implements ICustomStateMapper {
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    protected boolean flammable;
    protected boolean dense = false;
    protected int flammability = 0;

    public BlockBuildCraftFluid(Fluid fluid, Material material) {
        super(fluid, material);
        int colour = fluid.getColor();
        this.setParticleColor(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public IBlockState func_176203_a(int meta) {
        meta = (meta % 16 + 16) % 16;
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        super.func_176204_a(world, pos, state, block);
        if (this.flammable && world.field_73011_w.func_177502_q() == -1) {
            world.func_175698_g(pos);
            world.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.0f, true, true);
        }
    }

    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material materialIn) {
        if (materialIn == Material.field_151586_h && !this.dense) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Boolean isEntityInsideMaterial(World world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (materialIn == Material.field_151586_h && !this.dense) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!this.dense || entity == null) {
            return;
        }
        entity.field_70181_x = Math.min(0.0, entity.field_70181_x);
        if (entity.field_70181_x < -0.05) {
            entity.field_70181_x *= 0.05;
        }
        entity.field_70159_w = Math.max(-0.05, Math.min(0.05, entity.field_70159_w * 0.05));
        entity.field_70181_x -= 0.05;
        entity.field_70179_y = Math.max(-0.05, Math.min(0.05, entity.field_70179_y * 0.05));
    }

    public BlockBuildCraftFluid setDense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public BlockBuildCraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockBuildCraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.flammable && this.flammability == 0;
    }

    public BlockBuildCraftFluid setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180655_c(world, pos, state, rand);
        if (rand.nextInt(10) == 0 && World.func_175683_a((IBlockAccess)world, (BlockPos)pos.func_177977_b()) && !world.func_180495_p(pos.func_177979_c(2)).func_177230_c().func_149688_o().func_76230_c()) {
            double px = (float)pos.func_177958_n() + rand.nextFloat();
            double py = (double)pos.func_177956_o() - 1.05;
            double pz = (float)pos.func_177952_p() + rand.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setCusomStateMappers() {
        final ModelResourceLocation loc = ModelHelper.getBlockResourceLocation((Block)this);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return loc;
            }
        });
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.TRANSLUCENT;
    }
}

