/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.api.core.EnumColor;
import buildcraft.api.enums.EnumBlueprintType;
import buildcraft.api.enums.EnumDecoratedBlock;
import buildcraft.api.enums.EnumEnergyStage;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumFillerPattern;
import buildcraft.api.enums.EnumLaserTableType;
import buildcraft.api.enums.EnumSpring;
import buildcraft.api.properties.BuildCraftExtendedProperty;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.properties.BuildCraftProperty;
import buildcraft.core.BCCreativeTab;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBuildCraftBase
extends Block {
    public static final BuildCraftProperty<EnumFacing> FACING_PROP = BuildCraftProperties.BLOCK_FACING;
    public static final BuildCraftProperty<EnumFacing> FACING_6_PROP = BuildCraftProperties.BLOCK_FACING_6;
    public static final BuildCraftProperty<EnumEngineType> ENGINE_TYPE = BuildCraftProperties.ENGINE_TYPE;
    public static final BuildCraftProperty<EnumColor> COLOR_PROP = BuildCraftProperties.BLOCK_COLOR;
    public static final BuildCraftProperty<EnumSpring> SPRING_TYPE = BuildCraftProperties.SPRING_TYPE;
    public static final BuildCraftProperty<EnumEnergyStage> ENERGY_STAGE = BuildCraftProperties.ENERGY_STAGE;
    public static final BuildCraftProperty<EnumFillerPattern> FILLER_PATTERN = BuildCraftProperties.FILLER_PATTERN;
    public static final BuildCraftProperty<EnumBlueprintType> BLUEPRINT_TYPE = BuildCraftProperties.BLUEPRINT_TYPE;
    public static final BuildCraftProperty<EnumLaserTableType> LASER_TABLE_TYPE = BuildCraftProperties.LASER_TABLE_TYPE;
    public static final BuildCraftProperty<EnumDecoratedBlock> DECORATED_TYPE = BuildCraftProperties.DECORATED_BLOCK;
    public static final BuildCraftProperty<Integer> GENERIC_PIPE_DATA = BuildCraftProperties.GENERIC_PIPE_DATA;
    public static final BuildCraftProperty<Boolean> JOINED_BELOW = BuildCraftProperties.JOINED_BELOW;
    public static final BuildCraftProperty<Boolean> MOVING = BuildCraftProperties.MOVING;
    public static final BuildCraftProperty<Integer> LED_POWER = BuildCraftProperties.LED_POWER;
    public static final BuildCraftProperty<Boolean> LED_DONE = BuildCraftProperties.LED_DONE;
    public static final BuildCraftProperty<Boolean> CONNECTED_UP = BuildCraftProperties.CONNECTED_UP;
    public static final BuildCraftProperty<Boolean> CONNECTED_DOWN = BuildCraftProperties.CONNECTED_DOWN;
    public static final BuildCraftProperty<Boolean> CONNECTED_EAST = BuildCraftProperties.CONNECTED_EAST;
    public static final BuildCraftProperty<Boolean> CONNECTED_WEST = BuildCraftProperties.CONNECTED_WEST;
    public static final BuildCraftProperty<Boolean> CONNECTED_NORTH = BuildCraftProperties.CONNECTED_NORTH;
    public static final BuildCraftProperty<Boolean> CONNECTED_SOUTH = BuildCraftProperties.CONNECTED_SOUTH;
    public static final Map<EnumFacing, BuildCraftProperty<Boolean>> CONNECTED_MAP = BuildCraftProperties.CONNECTED_MAP;
    public static final BuildCraftProperty<Boolean>[] CONNECTED_ARRAY = CONNECTED_MAP.values().toArray(new BuildCraftProperty[6]);
    protected BuildCraftProperty<?>[] properties;
    protected BuildCraftProperty<?>[] nonMetaProperties;
    protected BuildCraftExtendedProperty<?>[] extendedProperties;
    protected boolean hasExtendedProperties;
    protected List<BuildCraftProperty<?>> propertyList;
    protected final Map<Integer, IBlockState> intToState = Maps.newHashMap();
    protected final Map<IBlockState, Integer> stateToInt = Maps.newHashMap();
    protected final BlockState myBlockState;
    public boolean horizontallyRotatable;
    public boolean allRotatable;

    protected BlockBuildCraftBase(Material material) {
        this(material, BCCreativeTab.get("main"), false, new BuildCraftProperty[0]);
    }

    protected BlockBuildCraftBase(Material material, BCCreativeTab creativeTab) {
        this(material, creativeTab, false, new BuildCraftProperty[0]);
    }

    protected BlockBuildCraftBase(Material material, BuildCraftProperty<?> ... properties) {
        this(material, BCCreativeTab.get("main"), false, properties);
    }

    protected BlockBuildCraftBase(Material material, BCCreativeTab bcCreativeTab, BuildCraftProperty<?> ... properties) {
        this(material, bcCreativeTab, false, properties);
    }

    protected BlockBuildCraftBase(Material material, BCCreativeTab bcCreativeTab, boolean hasExtendedProps, BuildCraftProperty<?> ... properties) {
        super(material);
        this.func_149647_a(bcCreativeTab);
        this.func_149711_c(5.0f);
        ArrayList metas = Lists.newArrayList();
        ArrayList nonMetas = Lists.newArrayList();
        ArrayList infinites = Lists.newArrayList();
        this.hasExtendedProperties = this.fillStateListsPre(hasExtendedProps, metas, nonMetas, infinites, properties);
        this.properties = metas.toArray(new BuildCraftProperty[0]);
        this.nonMetaProperties = nonMetas.toArray(new BuildCraftProperty[0]);
        this.extendedProperties = infinites.toArray(new BuildCraftExtendedProperty[0]);
        this.myBlockState = this.func_180661_e();
        this.fillStateMapPost(metas, nonMetas, properties);
    }

    protected boolean fillStateListsPre(boolean hasExtendedProps, List<BuildCraftProperty<?>> metas, List<BuildCraftProperty<?>> nonMetas, List<BuildCraftExtendedProperty<?>> infinites, BuildCraftProperty<?> ... properties) {
        int total = 1;
        for (BuildCraftProperty<?> prop : properties) {
            if (prop == null) continue;
            if (prop instanceof BuildCraftExtendedProperty) {
                infinites.add((BuildCraftExtendedProperty)prop);
                hasExtendedProps = true;
                continue;
            }
            if ((total *= prop.getAllowedValues().size()) > 16) {
                nonMetas.add(prop);
                continue;
            }
            metas.add(prop);
        }
        return hasExtendedProps;
    }

    protected void fillStateMapPost(List<BuildCraftProperty<?>> metas, List<BuildCraftProperty<?>> nonMetas, BuildCraftProperty<?> ... properties) {
        IBlockState defaultState = this.func_176194_O().func_177621_b();
        HashMap tempValidStates = Maps.newHashMap();
        tempValidStates.put(defaultState, 0);
        boolean canRotate = false;
        boolean canSixRotate = false;
        for (BuildCraftProperty<?> prop : properties) {
            if (prop == null || prop instanceof BuildCraftExtendedProperty) continue;
            if (prop == FACING_PROP) {
                canRotate = true;
            }
            if (prop == FACING_6_PROP) {
                canRotate = true;
                canSixRotate = true;
            }
            List<?> allowedValues = prop.getAllowedValues();
            defaultState = this.withProperty(defaultState, prop, (Comparable)allowedValues.iterator().next());
            HashMap newValidStates = Maps.newHashMap();
            int mul = metas.contains(prop) ? allowedValues.size() : 1;
            for (Map.Entry entry : tempValidStates.entrySet()) {
                int index = 0;
                Collections.sort(allowedValues);
                for (Comparable comp : allowedValues) {
                    int pos = (Integer)entry.getValue() * mul + index;
                    newValidStates.put(this.withProperty((IBlockState)entry.getKey(), prop, comp), pos);
                    if (mul <= 1) continue;
                    ++index;
                }
            }
            tempValidStates = newValidStates;
        }
        this.horizontallyRotatable = canRotate;
        this.allRotatable = canSixRotate;
        for (Map.Entry entry : tempValidStates.entrySet()) {
            int i = (Integer)entry.getValue();
            this.stateToInt.put((IBlockState)entry.getKey(), i);
            if (this.intToState.containsKey(i)) continue;
            this.intToState.put(i, (IBlockState)entry.getKey());
        }
        this.func_180632_j(defaultState);
        ArrayList allProperties = Lists.newArrayList();
        allProperties.addAll(metas);
        allProperties.addAll(nonMetas);
        this.propertyList = Collections.unmodifiableList(allProperties);
    }

    private IBlockState withProperty(IBlockState state, BuildCraftProperty prop, Comparable value) {
        return this.withProperty0(state, prop, value);
    }

    private <V extends Comparable<V>, T extends V> IBlockState withProperty0(IBlockState state, BuildCraftProperty<V> prop, T value) {
        return state.func_177226_a(prop, value);
    }

    public BlockState func_176194_O() {
        return this.myBlockState;
    }

    protected BlockState func_180661_e() {
        if (this.properties == null) {
            return new BlockState((Block)this, new IProperty[0]);
        }
        IProperty[] props = new IProperty[this.properties.length + this.nonMetaProperties.length];
        System.arraycopy(this.properties, 0, props, 0, this.properties.length);
        System.arraycopy(this.nonMetaProperties, 0, props, this.properties.length, this.nonMetaProperties.length);
        if (this.hasExtendedProperties) {
            return new ExtendedBlockState((Block)this, props, (IUnlistedProperty[])this.extendedProperties);
        }
        return new BlockState((Block)this, props);
    }

    public int func_176201_c(IBlockState state) {
        return this.stateToInt.containsKey(state) ? this.stateToInt.get(state) : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.intToState.containsKey(meta) ? this.intToState.get(meta) : this.func_176223_P();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.allRotatable) {
            return this.func_176203_a(meta).func_177226_a(FACING_6_PROP, (Comparable)facing);
        }
        return this.func_176203_a(meta);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (this.horizontallyRotatable && !this.allRotatable) {
            EnumFacing orientation = entity.func_174811_aO();
            world.func_175656_a(pos, state.func_177226_a(FACING_PROP, (Comparable)orientation.func_176734_d()));
        }
    }

    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public AxisAlignedBB[] getBoxes(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB[]{this.getBox(world, pos, state)};
    }

    public MovingObjectPosition collisionRayTrace_super(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        return super.func_180636_a(world, pos, origin, direction);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB[] aabbs = this.getBoxes((IBlockAccess)world, pos, state);
        MovingObjectPosition closest = null;
        for (AxisAlignedBB aabb : aabbs) {
            MovingObjectPosition mop = (aabb = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72314_b(-0.01, -0.01, -0.01)).func_72327_a(origin, direction);
            if (mop == null || closest != null && !(mop.field_72307_f.func_72438_d(origin) < closest.field_72307_f.func_72438_d(origin))) continue;
            closest = mop;
        }
        if (closest == null) {
            return null;
        }
        return new MovingObjectPosition(closest.field_72307_f, closest.field_178784_b, pos);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity par7Entity) {
        if (!this.func_149703_v()) {
            return;
        }
        for (AxisAlignedBB bb : this.getBoxes((IBlockAccess)world, pos, state)) {
            if (!mask.func_72326_a(bb = bb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
            list.add(bb);
        }
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        if (this.func_149703_v()) {
            return this.getBox((IBlockAccess)world, pos, state).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return this.getBox((IBlockAccess)world, pos, world.func_180495_p(pos)).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }
}

