/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import buildcraft.api.core.SafeTimeTracker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class TileBuffer {
    private IBlockState state = null;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker(20L, 5L);
    private final World world;
    private final BlockPos pos;
    private final boolean loadUnloaded;

    public TileBuffer(World world, BlockPos pos, boolean loadUnloaded) {
        if (world == null) {
            throw new NullPointerException("world");
        }
        this.world = world;
        this.pos = pos;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public void refresh() {
        this.tile = null;
        this.state = null;
        this.state = this.world.func_180495_p(this.pos);
        this.tile = this.world.func_175625_s(this.pos);
    }

    public void set(IBlockState state, TileEntity tile) {
        this.state = state;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    private void tryRefresh() {
        this.refresh();
    }

    public IBlockState getBlockState() {
        this.tryRefresh();
        return this.state;
    }

    public TileEntity getTile() {
        return this.getTile(false);
    }

    public TileEntity getTile(boolean forceUpdate) {
        this.refresh();
        return this.tile;
    }

    public boolean exists() {
        return this.world.func_175667_e(this.pos);
    }

    public static TileBuffer[] makeBuffer(World world, BlockPos pos, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            buffer[face.ordinal()] = new TileBuffer(world, pos.func_177972_a(face), loadUnloaded);
        }
        return buffer;
    }
}

