/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.config.DetailedConfigOption;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IWorldAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebuggingTools {
    public static final DetailedConfigOption OPTION_PRINT_RENDER_UPDATES = new DetailedConfigOption("debug.tool.render.update", "false");

    public static void init() {
        EventHook hook = new EventHook();
        boolean use = false;
        if (OPTION_PRINT_RENDER_UPDATES.getAsBoolean()) {
            hook.renderUpdate = true;
            use = true;
        }
        if (use) {
            MinecraftForge.EVENT_BUS.register((Object)hook);
        }
    }

    private static class WorldListener
    implements IWorldAccess {
        private final boolean renderUpdate;

        public WorldListener(EventHook hook) {
            this.renderUpdate = hook.renderUpdate;
        }

        public void func_174960_a(BlockPos pos) {
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
            if (this.renderUpdate) {
                int i;
                StackTraceElement[] elements = new Throwable().getStackTrace();
                String[] bc = new String[elements.length];
                int bcIndex = 0;
                for (i = 1; i < elements.length; ++i) {
                    StackTraceElement ste = elements[i];
                    if (!ste.getClassName().startsWith("buildcraft")) continue;
                    bc[bcIndex++] = ste.getClassName() + " # " + ste.getMethodName() + " : " + ste.getLineNumber();
                }
                if (bcIndex > 0) {
                    BCLog.logger.info("markBlockRangeForRenderUpdate(" + x1 + ", " + y1 + ", " + z1 + ", " + x2 + ", " + y2 + ", " + z2 + ")");
                    for (i = 0; i < bcIndex; ++i) {
                        BCLog.logger.info("  at " + bc[i]);
                    }
                }
            }
        }

        public void func_72704_a(String soundName, double x, double y, double z, float volume, float pitch) {
        }

        public void func_85102_a(EntityPlayer except, String soundName, double x, double y, double z, float volume, float pitch) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... parameters) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_174961_a(String recordName, BlockPos blockPosIn) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int sfxType, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }
    }

    private static class EventHook {
        private boolean renderUpdate;

        private EventHook() {
        }

        @SubscribeEvent
        public void worldLoadEvent(WorldEvent.Load load) {
            load.world.func_72954_a((IWorldAccess)new WorldListener(this));
        }
    }
}

