/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.client;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IBox;
import buildcraft.api.items.IMapLocation;
import buildcraft.core.EntityLaser;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.LaserData;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.render.RenderLaser;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public enum RenderTickListener {
    INSTANCE;

    private static final Vec3[][][] MAP_LOCATION_POINT;

    @SubscribeEvent
    public void tick(RenderWorldLastEvent event) {
        float partialTicks = event.partialTicks;
        RenderTickListener.renderHeldItemInWorld(partialTicks);
    }

    private static void renderHeldItemInWorld(float partialTicks) {
        Item item;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_175598_ae().field_78734_h == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack held = player.func_70694_bm();
        WorldClient world = mc.field_71441_e;
        mc.field_71424_I.func_76320_a("bc");
        mc.field_71424_I.func_76320_a("renderWorld");
        RenderTickListener.fromPlayerPreGl((EntityPlayer)player, partialTicks);
        if (held != null && held.field_77994_a > 0 && (item = player.func_70694_bm().func_77973_b()) == BuildCraftCore.mapLocationItem) {
            RenderTickListener.renderMapLocation(world, player.func_70694_bm());
        }
        RenderTickListener.fromPlayerPostGl();
        mc.field_71424_I.func_76319_b();
        mc.field_71424_I.func_76319_b();
    }

    private static void fromPlayerPreGl(EntityPlayer player, float partialTicks) {
        GL11.glPushMatrix();
        Vec3 diff = new Vec3(0.0, 0.0, 0.0);
        diff = diff.func_178788_d(player.func_174824_e(partialTicks));
        diff = diff.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        GL11.glTranslated((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c);
    }

    private static void fromPlayerPostGl() {
        GL11.glPopMatrix();
    }

    private static void renderMapLocation(WorldClient world, ItemStack stack) {
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(stack);
        if (type == IMapLocation.MapLocationType.SPOT) {
            EnumFacing face = ItemMapLocation.getPointFace(stack);
            IBox box = ItemMapLocation.getPointBox(stack);
            Vec3[][] vectors = MAP_LOCATION_POINT[face.ordinal()];
            GL11.glTranslated((double)box.min().func_177958_n(), (double)box.min().func_177956_o(), (double)box.min().func_177952_p());
            for (Vec3[] vec : vectors) {
                LaserData laser = new LaserData(vec[0], vec[1]);
                RenderLaser.doRenderLaser((World)world, Minecraft.func_71410_x().func_110434_K(), laser, EntityLaser.LASER_STRIPES_YELLOW);
            }
        } else if (type == IMapLocation.MapLocationType.AREA) {
            LaserData[] laserBox;
            IBox box = ItemMapLocation.getAreaBox(stack);
            for (LaserData laser : laserBox = Utils.createLaserDataBox(new Vec3((Vec3i)box.min()), new Vec3((Vec3i)box.max().func_177982_a(1, 1, 1)))) {
                RenderLaser.doRenderLaser((World)world, Minecraft.func_71410_x().func_110434_K(), laser, EntityLaser.LASER_STRIPES_YELLOW);
            }
        } else if (type == IMapLocation.MapLocationType.PATH || type == IMapLocation.MapLocationType.ZONE) {
            // empty if block
        }
    }

    static {
        MAP_LOCATION_POINT = new Vec3[6][][];
        double[][][] upFace = new double[][][]{new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.6, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.8, 1.2, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.2, 1.2, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.2, 0.8}}, new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.2, 0.2}}};
        for (EnumFacing face : EnumFacing.values()) {
            Matrix4f matrix = MatrixUtils.rotateTowardsFace(EnumFacing.UP, face);
            Vec3[][] arr = new Vec3[5][2];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Vec3 to;
                    double[] from = upFace[i][j];
                    Point3f point = new Point3f(new Point3d(from));
                    matrix.transform(point);
                    arr[i][j] = to = new Vec3((double)point.x, (double)point.y, (double)point.z);
                }
            }
            RenderTickListener.MAP_LOCATION_POINT[face.ordinal()] = arr;
        }
    }
}

