/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.lib.utils.BCStringUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatternParameterXZDir
implements IStatementParameter {
    private static final String[] names = new String[]{"west", "east", "north", "south"};
    private static final int[] shiftLeft = new int[]{3, 2, 0, 1};
    private static final int[] shiftRight = new int[]{2, 3, 1, 0};
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite[] sprites;
    private int direction;

    @SideOnly(value=Side.CLIENT)
    public static void registerSprites(TextureMap map) {
        sprites = new TextureAtlasSprite[4];
        PatternParameterXZDir.sprites[0] = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/arrow_left"));
        PatternParameterXZDir.sprites[1] = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/arrow_right"));
        PatternParameterXZDir.sprites[2] = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/arrow_up"));
        PatternParameterXZDir.sprites[3] = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/arrow_down"));
    }

    public PatternParameterXZDir() {
    }

    public PatternParameterXZDir(int direction) {
        this();
        this.direction = direction;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterXZDir";
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return sprites[this.direction & 3];
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("direction." + names[this.direction & 3]);
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        this.direction = shiftRight[this.direction & 3];
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.direction = compound.func_74771_c("dir");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("dir", (byte)this.direction);
    }

    @Override
    public IStatementParameter rotateLeft() {
        return new PatternParameterXZDir(shiftLeft[this.direction & 3]);
    }

    public int getDirection() {
        return this.direction;
    }
}

